/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import snaq.util.jclap.CLAParser;
import snaq.util.jclap.OptionException;

public abstract class Option<E> {
    protected static final String ILLEGAL_SN_CHARS = "-";
    protected static final int MIN_COUNT_LIMIT = 0;
    protected static final int MAX_COUNT_LIMIT = 100;
    protected static final Locale locale = CLAParser.getLocale();
    protected static final ResourceBundle bundle = CLAParser.getResources();
    private String shortName;
    private String longName;
    private String description;
    private boolean requiresValue = false;
    private int minCount = 0;
    private int maxCount = 100;
    protected List<E> values = new ArrayList();
    private boolean hideFromUsage = false;

    protected Option(String shortName, String longName, String description, boolean requiresValue, int minCount, int maxCount) {
        if (shortName == null) {
            throw new IllegalArgumentException(bundle.getString("err.NullShortName"));
        }
        if (shortName.length() != 1 || ILLEGAL_SN_CHARS.contains(shortName)) {
            throw new IllegalArgumentException(bundle.getString("err.BadShortName"));
        }
        if (longName != null && longName.length() < 2) {
            throw new IllegalArgumentException(bundle.getString("err.BadLongName"));
        }
        if (minCount < 0) {
            throw new IllegalArgumentException(bundle.getString("err.InvalidMinCount"));
        }
        if (maxCount < minCount || maxCount > 100) {
            throw new IllegalArgumentException(bundle.getString("err.InvalidMaxCount"));
        }
        this.shortName = shortName;
        this.longName = longName;
        this.description = description;
        this.requiresValue = requiresValue;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    protected Option(String shortName, String longName, String description, boolean requiresValue, boolean mandatory, boolean allowMany) {
        this(shortName, longName, description, requiresValue, mandatory ? 1 : 0, allowMany ? 100 : 1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        return !(this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName));
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + (this.shortName != null ? this.shortName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[-");
        sb.append(this.shortName);
        if (this.longName != null) {
            sb.append(",--");
            sb.append(this.longName);
        }
        sb.append(",");
        sb.append(this.getType().getName());
        sb.append("]");
        return sb.toString();
    }

    public abstract Class<E> getType();

    protected String getUsageTypeString() {
        String valType = this.getType().getName();
        valType = valType.substring(valType.lastIndexOf(46) + 1);
        String usageType = null;
        try {
            usageType = bundle.getString("option.type." + valType);
        }
        catch (MissingResourceException mrx) {
            usageType = bundle.getString("option.type.unknown");
        }
        return usageType;
    }

    public List<E> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    protected void addValue(E value) throws OptionException {
        if (this.maxCount == 0) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, value.toString());
        }
        if (this.maxCount == 1 && !this.values.isEmpty()) {
            throw new OptionException(OptionException.Type.OPTION_HAS_VALUE, this, value.toString());
        }
        if (this.values.size() >= this.maxCount) {
            throw new OptionException(OptionException.Type.INVALID_OPTION_VALUE_COUNT, this, value.toString());
        }
        this.values.add(value);
    }

    protected abstract E parseValue(String var1) throws OptionException;

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public boolean isMandatory() {
        return this.minCount > 0;
    }

    public boolean isAllowMany() {
        return this.maxCount > 1;
    }

    public void setMinMaxCounts(int minCount, int maxCount) {
        if (minCount < 0) {
            throw new IllegalArgumentException(bundle.getString("err.InvalidMinCount"));
        }
        if (maxCount < minCount || maxCount > 100) {
            throw new IllegalArgumentException(bundle.getString("err.InvalidMaxCount"));
        }
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public Option<E> setHidden() {
        this.hideFromUsage = true;
        return this;
    }

    public boolean isHidden() {
        return this.hideFromUsage;
    }
}

