/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.io.File;
import java.io.IOException;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public class StringOption
extends Option<String> {
    private Filter filter;

    public StringOption(String shortName, String longName, String description, int minCount, int maxCount) {
        super(shortName, longName, description, true, minCount, maxCount);
    }

    public StringOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        super(shortName, longName, description, true, mandatory, allowMany);
    }

    @Override
    protected String parseValue(String arg) throws OptionException {
        if (this.filter == null) {
            return arg;
        }
        if (this.filter.accept(arg)) {
            return arg;
        }
        throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    public static final class FileFilter
    implements Filter {
        private AcceptExistance eType = AcceptExistance.ACCEPT_ALL;
        private AcceptFileType fType = AcceptFileType.ACCEPT_ALL;

        public FileFilter(AcceptExistance eType, AcceptFileType fType) {
            this.eType = eType;
            this.fType = fType;
        }

        @Override
        public boolean accept(String arg) {
            try {
                File f = new File(arg).getCanonicalFile();
                switch (this.eType) {
                    case ACCEPT_NON_EXISTING: {
                        if (!f.exists()) break;
                        return false;
                    }
                    case ACCEPT_EXISTING: {
                        if (f.exists()) break;
                        return false;
                    }
                }
                switch (this.fType) {
                    case ACCEPT_DIR: {
                        if (f.isDirectory()) break;
                        return false;
                    }
                    case ACCEPT_FILE: {
                        if (f.isFile()) break;
                        return false;
                    }
                    case ACCEPT_ALL: {
                        if (!f.isFile() && !f.isDirectory()) break;
                        return true;
                    }
                }
                return true;
            }
            catch (IOException iox) {
                return false;
            }
        }

        public static enum AcceptFileType {
            ACCEPT_FILE,
            ACCEPT_DIR,
            ACCEPT_ALL;

        }

        public static enum AcceptExistance {
            ACCEPT_EXISTING,
            ACCEPT_NON_EXISTING,
            ACCEPT_ALL;

        }
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

