/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import snaq.util.jclap.CLAParser;
import snaq.util.jclap.Option;

public final class OptionException
extends Exception {
    protected static final Locale locale = CLAParser.getLocale();
    protected static final ResourceBundle bundle = CLAParser.getResources();
    protected static final ResourceBundle baseBundle = CLAParser.getBaseResources();
    private Type type;
    private Option option = null;
    private String optionName = null;
    private String optionValue = null;
    private String flag = null;

    public OptionException(Type type, Option option, String optionValue) {
        this(type, option);
        this.optionValue = optionValue;
    }

    public OptionException(Type type, String optionName, String optionValue) {
        this(type, optionName);
        this.optionValue = optionValue;
    }

    public OptionException(Type type, String optionName, char flag) {
        this(type, optionName);
        this.flag = new String(new char[]{flag});
    }

    public OptionException(Type type, Option option) {
        this.type = type;
        this.option = option;
    }

    public OptionException(Type type, String optionName) {
        this.type = type;
        this.optionName = optionName;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(baseBundle);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(bundle);
    }

    private String getLocalizedMessage(ResourceBundle rb) {
        String msg = null;
        Object[] args = null;
        String optionStr = this.optionName;
        if (this.option != null) {
            optionStr = this.option.getLongName() != null ? "-" + this.option.getShortName() + ",--" + this.option.getLongName() : "-" + this.option.getShortName();
        }
        switch (this.type) {
            case INVALID_RETRIEVAL_TYPE: {
                msg = rb.getString("err.InvalidRetrievalType");
                args = new Object[]{optionStr};
                break;
            }
            case UNKNOWN_OPTION: {
                msg = rb.getString("err.UnknownOption");
                args = new Object[]{optionStr};
                break;
            }
            case UNKNOWN_FLAG: {
                msg = rb.getString("err.UnknownFlag");
                args = new Object[]{optionStr, this.flag};
                break;
            }
            case NOT_FLAG: {
                msg = rb.getString("err.NotFlag");
                args = new Object[]{optionStr, this.flag};
                break;
            }
            case ILLEGAL_OPTION_VALUE: {
                msg = rb.getString("err.IllegalOptionValue");
                args = new Object[]{optionStr, this.optionValue};
                break;
            }
            case INVALID_OPTION_COUNT: {
                msg = rb.getString("err.InvalidOptionValueCount");
                args = new Object[]{optionStr, this.optionValue};
                break;
            }
            case OPTION_HAS_VALUE: {
                msg = rb.getString("err.OptionHasValue");
                args = new Object[]{optionStr, this.optionValue};
                break;
            }
            case INVALID_OPTION_VALUE_COUNT: {
                msg = rb.getString("err.InvalidOptionValueCount");
                args = new Object[]{optionStr, this.optionValue, this.option.getMinCount(), this.option.getMaxCount()};
                break;
            }
        }
        return MessageFormat.format(msg, args);
    }

    public static enum Type {
        INVALID_RETRIEVAL_TYPE,
        UNKNOWN_OPTION,
        UNKNOWN_FLAG,
        NOT_FLAG,
        ILLEGAL_OPTION_VALUE,
        INVALID_OPTION_COUNT,
        OPTION_HAS_VALUE,
        INVALID_OPTION_VALUE_COUNT;

    }
}

