/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.text.NumberFormat;
import java.text.ParseException;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public class FloatOption
extends Option<Float> {
    public FloatOption(String shortName, String longName, String description, int minCount, int maxCount) {
        super(shortName, longName, description, true, minCount, maxCount);
    }

    public FloatOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        super(shortName, longName, description, true, mandatory, allowMany);
    }

    @Override
    protected Float parseValue(String arg) throws OptionException {
        try {
            NumberFormat format = NumberFormat.getNumberInstance(locale);
            Number num = format.parse(arg);
            return new Float(num.floatValue());
        }
        catch (ParseException px) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }

    @Override
    protected String getUsageTypeString() {
        return bundle.getString("option.type.Float");
    }
}

