/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.util.Collection;
import snaq.util.jclap.EnumeratedOption;
import snaq.util.jclap.OptionException;

public final class EnumeratedStringOption
extends EnumeratedOption<String> {
    private boolean ignoreCase = true;

    public EnumeratedStringOption(String shortName, String longName, String description, int minCount, int maxCount, Collection<String> allowedValues, boolean ignoreCase) {
        super(shortName, longName, description, minCount, maxCount, allowedValues);
    }

    public EnumeratedStringOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany, Collection<String> allowedValues, boolean ignoreCase) {
        super(shortName, longName, description, mandatory, allowMany, allowedValues);
    }

    @Override
    protected String parseValue(String arg) throws OptionException {
        for (String s : this.allowedValues) {
            if ((!this.ignoreCase || !s.equalsIgnoreCase(arg)) && (this.ignoreCase || !s.equals(arg))) continue;
            return arg;
        }
        throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public String getAllowedValuesString() {
        return this.getAllowedValuesString("\"", ", ");
    }
}

