/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import snaq.util.jclap.CLAParser;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public class DateOption
extends Option<Date> {
    private static final DateFormat df = DateFormat.getDateInstance(3, CLAParser.getLocale());

    public DateOption(String shortName, String longName, String description, boolean requiresValue, boolean mandatory, boolean allowMany) {
        super(shortName, longName, description, requiresValue, mandatory, allowMany);
    }

    public DateOption(String shortName, String longName, String description, boolean requiresValue, int minCount, int maxCount) {
        super(shortName, longName, description, requiresValue, minCount, maxCount);
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    @Override
    protected Date parseValue(String arg) throws OptionException {
        if (arg == null) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
        try {
            return df.parse(arg);
        }
        catch (ParseException px) {
            px.printStackTrace();
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this);
        }
    }

    public DateFormat getDateFormat() {
        return df;
    }

    public static void main(String[] args) throws OptionException {
        CLAParser parser = new CLAParser();
        String desc = String.format("Date (short format, e.g. \"%s\")", df.format(Calendar.getInstance().getTime()));
        parser.addOption(new DateOption("d", "date", desc, true, true, true));
        parser.addBooleanOption("?", "help", "Displays help information.", false);
        try {
            parser.parse(args);
            if (parser.getBooleanOptionValue("?").booleanValue()) {
                parser.printUsage(System.out, true);
                System.exit(0);
            }
            List<Date> dates = parser.getOptionValues("d", Date.class);
            for (Date d : dates) {
                System.out.printf("Date specified: %s\n", df.format(d));
            }
        }
        catch (OptionException ox) {
            try {
                if (parser.getBooleanOptionValue("?").booleanValue()) {
                    parser.printUsage(System.out, true);
                    System.exit(0);
                }
                System.err.println(ox.getMessage());
                parser.printUsage(System.out, false);
                System.exit(1);
            }
            catch (OptionException ox2) {
                ox2.printStackTrace();
            }
        }
    }
}

