/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public final class BooleanOption
extends Option<Boolean> {
    protected static final String[] sTrue = bundle.getString("boolean.true").split(",");
    protected static final String[] sFalse = bundle.getString("boolean.false").split(",");

    public BooleanOption(String shortName, String longName, String description, int minCount, int maxCount) {
        super(shortName, longName, description, false, minCount, maxCount);
    }

    public BooleanOption(String shortName, String longName, String description, boolean allowMany) {
        super(shortName, longName, description, false, false, allowMany);
    }

    @Override
    protected Boolean parseValue(String arg) throws OptionException {
        if (arg == null) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
        String s = arg.toLowerCase().trim();
        for (String st : sTrue) {
            if (!s.equalsIgnoreCase(st)) continue;
            return Boolean.TRUE;
        }
        for (String sf : sFalse) {
            if (!s.equalsIgnoreCase(sf)) continue;
            return Boolean.FALSE;
        }
        throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    protected String getUsageTypeString() {
        return bundle.getString("option.type.Boolean");
    }
}

