/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

public class JDBCInfo {
    private static int verMajor = 0;
    private static int verMinor = 0;
    private static String verString = null;

    private JDBCInfo() {
    }

    public static synchronized String getVersionString() {
        if (verString != null) {
            return verString;
        }
        JDBCInfo.findVersion();
        return verString;
    }

    public static synchronized int getMajorVersion() {
        if (verMajor > 0) {
            return verMajor;
        }
        JDBCInfo.findVersion();
        return verMajor;
    }

    public static synchronized int getMinorVersion() {
        if (verMajor > 0) {
            return verMinor;
        }
        JDBCInfo.findVersion();
        return verMinor;
    }

    private static synchronized void findVersion() {
        if (JDBCInfo.testForJDBC42()) {
            verMajor = 4;
            verMinor = 2;
        } else if (JDBCInfo.testForJDBC41()) {
            verMajor = 4;
            verMinor = 1;
        } else if (JDBCInfo.testForJDBC40()) {
            verMajor = 4;
            verMinor = 0;
        } else if (JDBCInfo.testForJDBC30()) {
            verMajor = 3;
            verMinor = 0;
        } else if (JDBCInfo.testForJDBC21()) {
            verMajor = 2;
            verMinor = 1;
        } else if (JDBCInfo.testForJDBC12()) {
            verMajor = 1;
            verMinor = 2;
        } else {
            verMajor = 0;
            verMinor = 0;
            verString = "unknown";
        }
        verString = verMajor + "." + verMinor;
    }

    private static boolean testForJDBC42() {
        try {
            Class.forName("java.sql.DriverAction");
            Class.forName("java.sql.SQLType");
            Class.forName("java.sql.JDBCType");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static boolean testForJDBC41() {
        try {
            Class<?> k = Class.forName("java.sql.Connection");
            k.getMethod("setSchema", String.class);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean testForJDBC40() {
        try {
            Class.forName("java.sql.RowId");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static boolean testForJDBC30() {
        try {
            Class.forName("java.sql.Savepoint");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static boolean testForJDBC21() {
        try {
            Class.forName("java.sql.Struct");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static boolean testForJDBC12() {
        try {
            Class.forName("java.sql.Driver");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println();
        System.out.println("Operating System: " + System.getProperty("os.name"));
        System.out.println("OS Achitecture  : " + System.getProperty("os.arch"));
        System.out.println("OS Version      : " + System.getProperty("os.version"));
        System.out.println("Java Version    : " + System.getProperty("java.version"));
        System.out.println("Java Vendor     : " + System.getProperty("java.vendor"));
        System.out.println("Java VM Name    : " + System.getProperty("java.vm.name"));
        System.out.println();
        System.out.println("Your JVM supports JDBC " + JDBCInfo.getVersionString());
    }
}

