/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import javax.naming.InitialContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import snaq.db.DBPoolDataSource;

public class DBPoolServletContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(DBPoolServletContextListener.class);

    public void contextInitialized(ServletContextEvent evt) {
    }

    public void contextDestroyed(ServletContextEvent evt) {
        String name = evt.getServletContext().getInitParameter("name");
        if (name == null || name.trim().isEmpty()) {
            log.warn("Found invalid 'name' parameter in ServletContext");
        }
        try {
            InitialContext ctx = new InitialContext();
            Object o = ctx.lookup("java:comp/env/" + name);
            if (o == null || !(o instanceof DataSource)) {
                log.warn("ServletContext 'name' parameter doesn't refer to a DataSource: " + o);
                return;
            }
            DBPoolDataSource ds = (DBPoolDataSource)o;
            log.trace(String.format("Found compatible DBPoolDataSource (%s): releasing", ds.getName()));
            ds.release();
        }
        catch (Throwable t) {
            log.warn(t.getMessage(), t);
        }
    }
}

