/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import snaq.db.CacheConnection;
import snaq.db.ConnectionPoolEvent;
import snaq.db.ConnectionPoolListener;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.util.EventDispatcher;
import snaq.util.EventNotifier;
import snaq.util.JmxUtils;
import snaq.util.ObjectPool;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolListener;

public class ConnectionPool
extends ObjectPool<CacheConnection> {
    private String url;
    private String user;
    private String pass;
    private Properties props;
    private ConnectionValidator validator = new DefaultValidator();
    private PasswordDecoder decoder;
    private boolean cacheSS;
    private boolean cachePS;
    private boolean cacheCS;
    private final List<ConnectionPoolListener> listeners = new CopyOnWriteArrayList<ConnectionPoolListener>();
    private EventDispatcher<ConnectionPoolListener, ConnectionPoolEvent> eventDispatcher;
    private boolean recycleAfterDelegateUse = false;
    private boolean mbeanRegistered = false;
    private String mbeanRegisteredName;

    public ConnectionPool(String name, int minPool, int maxPool, int maxSize, long idleTimeout, String url, String username, String password) {
        super(name, minPool, maxPool, maxSize, idleTimeout);
        this.url = url;
        this.user = username;
        this.pass = password;
        this.props = null;
        this.setCaching(true);
        this.addObjectPoolListener(new EventRelay());
    }

    public ConnectionPool(String name, int maxPool, int maxSize, long idleTimeout, String url, String username, String password) {
        this(name, 0, maxPool, maxSize, idleTimeout, url, username, password);
    }

    public ConnectionPool(String name, int minPool, int maxPool, int maxSize, long idleTimeout, String url, Properties props) {
        this(name, minPool, maxPool, maxSize, idleTimeout, url, null, null);
        this.props = props;
        if (props != null) {
            this.pass = props.getProperty("password");
        }
    }

    public ConnectionPool(String name, int maxPool, int maxSize, long idleTimeout, String url, Properties props) {
        this(name, 0, maxPool, maxSize, idleTimeout, url, props);
    }

    public void registerMBean() {
        if (this.mbeanRegistered) {
            return;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            this.mbeanRegisteredName = "snaq.db:type=ConnectionPool,name=\"" + this.getName() + "\"";
            ObjectName name = new ObjectName(this.mbeanRegisteredName);
            mbs.registerMBean(JmxUtils.createObjectPoolMBean(this), name);
            this.mbeanRegistered = true;
            this.log_info("Registered MBean for JMX access");
        }
        catch (Exception ex) {
            this.log_warn("Unable to register pool with MBean server", ex);
        }
    }

    public void unregisterMBean() {
        if (!this.mbeanRegistered) {
            this.log_warn("Unable to unregister pool from MBean server: not registered");
            return;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(this.mbeanRegisteredName);
            mbs.unregisterMBean(name);
            this.mbeanRegistered = false;
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException ex) {
            this.log_warn("Unable to unregister pool from MBean server", ex);
        }
    }

    @Override
    protected CacheConnection create() throws SQLException {
        Connection con = null;
        CacheConnection ccon = null;
        try {
            if (this.props != null) {
                if (this.decoder != null) {
                    this.props.setProperty("password", new String(this.decoder.decode(this.pass)));
                }
                this.log_info("Getting connection (properties): " + this.url);
                con = DriverManager.getConnection(this.url, this.props);
                if (this.decoder != null) {
                    this.props.setProperty("password", this.pass);
                }
            } else if (this.user != null) {
                if (this.decoder != null) {
                    this.log_info("Getting connection (user/enc.password): " + this.url);
                    con = DriverManager.getConnection(this.url, this.user, new String(this.decoder.decode(this.pass)));
                } else {
                    this.log_info("Getting connection (user/password): " + this.url);
                    con = DriverManager.getConnection(this.url, this.user, this.pass);
                }
            } else {
                this.log_info("Getting connection (just URL): " + this.url);
                con = DriverManager.getConnection(this.url);
            }
            ccon = new CacheConnection(this, con);
            ccon.setCacheStatements(this.cacheSS);
            ccon.setCachePreparedStatements(this.cachePS);
            ccon.setCacheCallableStatements(this.cacheCS);
            this.log_info("Created a new connection");
            for (SQLWarning warn = con.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                this.log_info("Warning - " + warn.getMessage());
            }
        }
        catch (SQLException sqlx) {
            this.log_info("Can't create a new connection for " + this.url, sqlx);
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sqlx2) {
                this.log_warn("Unable to close connection", sqlx2);
            }
            throw sqlx;
        }
        return ccon;
    }

    @Override
    protected boolean isValid(CacheConnection cc) {
        if (cc == null) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        try {
            boolean valid = this.validator.isValid(cc.getRawConnection());
            if (!valid) {
                this.firePoolEvent(ObjectPoolEvent.Type.VALIDATION_ERROR);
            }
            return valid;
        }
        catch (SQLException sqlx) {
            this.log_debug("SQLException during validation", sqlx);
            return false;
        }
    }

    public void setValidator(ConnectionValidator cv) {
        this.validator = cv;
    }

    public ConnectionValidator getValidator() {
        return this.validator;
    }

    public void setPasswordDecoder(PasswordDecoder pd) {
        this.decoder = pd;
    }

    public PasswordDecoder getPasswordDecoder() {
        return this.decoder;
    }

    @Override
    protected void destroy(CacheConnection cc) {
        if (cc == null) {
            return;
        }
        try {
            cc.release();
            this.log_info("Destroyed connection");
        }
        catch (SQLException sqlx) {
            this.log_warn("Can't destroy connection", sqlx);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            CacheConnection cc = (CacheConnection)super.checkOut();
            if (cc != null) {
                cc.setOpen();
                return cc;
            }
            return null;
        }
        catch (Exception ex) {
            this.log_warn("Error getting connection", ex);
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
                this.log_warn("Error getting connection", ex);
            }
            throw new SQLException(ex.getMessage());
        }
    }

    public Connection getConnection(long timeout) throws SQLException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout value specified: " + timeout);
        }
        try {
            CacheConnection cc = (CacheConnection)super.checkOut(timeout);
            if (cc != null) {
                cc.setOpen();
                return cc;
            }
            return null;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            this.log_warn("Error getting connection", ex);
            throw new SQLException(ex.getMessage());
        }
    }

    protected void freeConnection(Connection c) throws SQLException {
        if (c == null || !CacheConnection.class.isInstance(c)) {
            this.log_warn("Attempt to return invalid item");
        } else {
            super.checkIn((CacheConnection)c);
        }
    }

    @Override
    protected void preRelease() {
        if (this.mbeanRegistered) {
            this.unregisterMBean();
        }
    }

    @Override
    protected void postRelease() {
        this.listeners.clear();
        if (this.eventDispatcher != null) {
            this.eventDispatcher.halt();
            try {
                this.eventDispatcher.join();
            }
            catch (InterruptedException ix) {
                this.log_warn("Interrupted during halting of event dispatch thread", ix);
            }
            this.eventDispatcher = null;
        }
    }

    @Override
    protected float getIdleTimeoutMultiplier() {
        return 1000.0f;
    }

    public final void setCaching(boolean b) {
        this.cachePS = this.cacheCS = b;
        this.cacheSS = this.cacheCS;
    }

    public void setCaching(boolean ss, boolean ps, boolean cs) {
        this.cacheSS = ss;
        this.cachePS = ps;
        this.cacheCS = cs;
    }

    public boolean isCachingStatements() {
        return this.cacheSS;
    }

    public boolean isCachingPreparedStatements() {
        return this.cachePS;
    }

    public boolean isCachingCallableStatements() {
        return this.cacheCS;
    }

    public final void setRecycleAfterDelegateUse(boolean b) {
        this.recycleAfterDelegateUse = b;
    }

    public boolean isRecycleAfterDelegateUse() {
        return this.recycleAfterDelegateUse;
    }

    @Override
    protected long getMinimumCleaningInterval() {
        return 1000L;
    }

    @Override
    protected long getMaximumCleaningInterval() {
        return 5000L;
    }

    public final void addConnectionPoolListener(ConnectionPoolListener listener) {
        this.listeners.add(listener);
    }

    public final void removeConnectionPoolListener(ConnectionPoolListener listener) {
        this.listeners.remove(listener);
    }

    private void firePoolEvent(ObjectPoolEvent.Type type) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, type);
        if (this.eventDispatcher == null) {
            this.eventDispatcher = new EventDispatcher<ConnectionPoolListener, ConnectionPoolEvent>(this.listeners, new Notifier());
            this.eventDispatcher.start();
        }
        this.eventDispatcher.dispatchEvent(poolEvent);
    }

    private void firePoolReleasedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, ObjectPoolEvent.Type.POOL_RELEASED);
        for (ConnectionPoolListener listener : this.listeners) {
            try {
                listener.poolReleased(poolEvent);
            }
            catch (RuntimeException rx) {
                this.log_warn("Exception thrown by listener on pool release", rx);
            }
        }
    }

    private final class Notifier
    implements EventNotifier<ConnectionPoolListener, ConnectionPoolEvent> {
        private Notifier() {
        }

        @Override
        public void notifyListener(ConnectionPoolListener cpl, ConnectionPoolEvent evt) {
            try {
                switch (evt.getType()) {
                    case INIT_COMPLETED: {
                        cpl.poolInitCompleted(evt);
                        break;
                    }
                    case CHECKOUT: {
                        cpl.poolCheckOut(evt);
                        break;
                    }
                    case CHECKIN: {
                        cpl.poolCheckIn(evt);
                        break;
                    }
                    case VALIDATION_ERROR: {
                        cpl.validationError(evt);
                        break;
                    }
                    case MAX_POOL_LIMIT_REACHED: {
                        cpl.maxPoolLimitReached(evt);
                        break;
                    }
                    case MAX_POOL_LIMIT_EXCEEDED: {
                        cpl.maxPoolLimitExceeded(evt);
                        break;
                    }
                    case MAX_SIZE_LIMIT_REACHED: {
                        cpl.maxSizeLimitReached(evt);
                        break;
                    }
                    case MAX_SIZE_LIMIT_ERROR: {
                        cpl.maxSizeLimitError(evt);
                        break;
                    }
                    case PARAMETERS_CHANGED: {
                        cpl.poolParametersChanged(evt);
                        break;
                    }
                    case POOL_FLUSHED: {
                        cpl.poolFlushed(evt);
                        break;
                    }
                    case POOL_RELEASED: {
                        cpl.poolReleased(evt);
                        break;
                    }
                }
            }
            catch (RuntimeException rx) {
                ConnectionPool.this.log_warn("Exception raised by pool listener", rx);
            }
        }
    }

    private final class EventRelay<T extends CacheConnection>
    implements ObjectPoolListener<T> {
        private EventRelay() {
        }

        @Override
        public void poolInitCompleted(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.INIT_COMPLETED);
        }

        @Override
        public void poolCheckOut(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.CHECKOUT);
        }

        @Override
        public void poolCheckIn(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.CHECKIN);
        }

        @Override
        public void validationError(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.VALIDATION_ERROR);
        }

        @Override
        public void maxPoolLimitReached(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.MAX_POOL_LIMIT_REACHED);
        }

        @Override
        public void maxPoolLimitExceeded(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.MAX_POOL_LIMIT_EXCEEDED);
        }

        @Override
        public void maxSizeLimitReached(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.MAX_SIZE_LIMIT_REACHED);
        }

        @Override
        public void maxSizeLimitError(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.MAX_SIZE_LIMIT_ERROR);
        }

        @Override
        public void poolParametersChanged(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.PARAMETERS_CHANGED);
        }

        @Override
        public void poolFlushed(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolEvent(ObjectPoolEvent.Type.POOL_FLUSHED);
        }

        @Override
        public void poolReleased(ObjectPoolEvent<T> evt) {
            ConnectionPool.this.firePoolReleasedEvent();
            ConnectionPool.this.listeners.clear();
        }
    }

    private static final class DefaultValidator
    implements ConnectionValidator {
        private DefaultValidator() {
        }

        @Override
        public boolean isValid(Connection con) {
            try {
                return con instanceof CacheConnection ? true : !con.isClosed();
            }
            catch (SQLException sqlx) {
                return false;
            }
        }
    }
}

