/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import snaq.db.CachedCallableStatement;
import snaq.db.CachedPreparedStatement;
import snaq.db.CachedStatement;
import snaq.db.ConnectionPool;
import snaq.db.StatementListener;
import snaq.util.Reusable;
import snaq.util.logging.LogUtil;

public final class CacheConnection
implements Connection,
StatementListener,
Reusable {
    protected Logger logger;
    private final LogUtil logUtil;
    private static final String MSG_CONNECTION_CLOSED = "Connection is closed";
    private static final int DEFAULT_RESULTSET_TYPE = 1003;
    private static final int DEFAULT_RESULTSET_CONCURRENCY = 1007;
    private static final int DEFAULT_RESULTSET_HOLDABILITY = 1;
    private final ConnectionPool pool;
    private final Connection con;
    private final List<CachedStatement> ss = new ArrayList<CachedStatement>();
    private final List<CachedStatement> ssUsed = new ArrayList<CachedStatement>();
    private final Map<String, List<CachedPreparedStatement>> ps = new HashMap<String, List<CachedPreparedStatement>>();
    private final List<CachedPreparedStatement> psUsed = new ArrayList<CachedPreparedStatement>();
    private final Map<String, List<CachedCallableStatement>> cs = new HashMap<String, List<CachedCallableStatement>>();
    private final List<CachedCallableStatement> csUsed = new ArrayList<CachedCallableStatement>();
    private final List<CachedStatement> nonCacheable = new ArrayList<CachedStatement>();
    private boolean cacheS;
    private boolean cacheP;
    private boolean cacheC;
    private int ssReq;
    private int ssHit;
    private int psReq;
    private int psHit;
    private int csReq;
    private int csHit;
    private boolean open = true;
    private boolean closing = false;
    private boolean usedDelegate = false;

    public CacheConnection(ConnectionPool pool, Connection con) {
        this.pool = pool;
        this.con = con;
        this.setCacheAll(true);
        this.csHit = 0;
        this.csReq = 0;
        this.psHit = 0;
        this.psReq = 0;
        this.ssHit = 0;
        this.ssReq = 0;
        this.logger = LoggerFactory.getLogger((String)(pool.getClass().getName() + "." + pool.getName()));
        this.logUtil = pool.getCustomLogger();
    }

    void setOpen() {
        this.open = true;
    }

    boolean isOpen() {
        return this.open;
    }

    public void setCacheStatements(boolean cache) {
        if (this.cacheS && !cache) {
            try {
                this.flushSpareStatements();
            }
            catch (SQLException sqlx) {
                this.log_warn(this.pool.getName() + ": " + sqlx.getMessage(), sqlx);
            }
        }
        this.cacheS = cache;
    }

    public void setCachePreparedStatements(boolean cache) {
        if (this.cacheP && !cache) {
            try {
                this.flushSparePreparedStatements();
            }
            catch (SQLException sqlx) {
                this.log_warn(this.pool.getName() + ": " + sqlx.getMessage(), sqlx);
            }
        }
        this.cacheP = cache;
    }

    public void setCacheCallableStatements(boolean cache) {
        if (this.cacheC && !cache) {
            try {
                this.flushSpareCallableStatements();
            }
            catch (SQLException sqlx) {
                this.log_warn(this.pool.getName() + ": " + sqlx.getMessage(), sqlx);
            }
        }
        this.cacheC = cache;
    }

    public void setCacheAll(boolean cache) {
        this.setCacheStatements(cache);
        this.setCachePreparedStatements(cache);
        this.setCacheCallableStatements(cache);
    }

    public boolean isCachingAllStatements() {
        return this.cacheS && this.cacheP && this.cacheC;
    }

    public boolean isCachingStatements() {
        return this.cacheS;
    }

    public boolean isCachingPreparedStatements() {
        return this.cacheP;
    }

    public boolean isCachingCallableStatements() {
        return this.cacheC;
    }

    public Connection getDelegateConnection() {
        this.usedDelegate = true;
        return this.con;
    }

    Connection getRawConnection() {
        return this.con;
    }

    protected final ConnectionPool getPool() {
        return this.pool;
    }

    protected void log_warn(String s) {
        this.logger.warn(s);
        if (this.logUtil != null) {
            this.logUtil.log(s);
        }
    }

    protected void log_warn(String s, Throwable throwable) {
        this.logger.warn(s, throwable);
        if (this.logUtil != null) {
            this.logUtil.log(s, throwable);
        }
    }

    protected void log_debug(String s) {
        this.logger.debug(s);
        if (this.logUtil != null) {
            this.logUtil.debug(s);
        }
    }

    protected void log_debug(String s, Throwable throwable) {
        this.logger.debug(s, throwable);
        if (this.logUtil != null) {
            this.logUtil.debug(s, throwable);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        List<CachedStatement> list;
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        CachedStatement cst = null;
        if (!this.cacheS) {
            cst = new CachedStatement(this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            cst.setCacheable(false);
            cst.setStatementListener(this);
            cst.setOpen();
        } else {
            list = this.ss;
            synchronized (list) {
                ++this.ssReq;
                Iterator<CachedStatement> it = this.ss.iterator();
                while (it.hasNext()) {
                    CachedStatement x = it.next();
                    x.setChecking(true);
                    if (x.getResultSetType() == resultSetType && x.getResultSetConcurrency() == resultSetConcurrency && x.getResultSetHoldability() == resultSetHoldability) {
                        cst = x;
                        it.remove();
                        break;
                    }
                    x.setChecking(false);
                }
                if (cst != null) {
                    cst.setOpen();
                    ++this.ssHit;
                    this.log_debug(this.pool.getName() + ": Statement cache hit [" + cst.getParametersString() + "] - " + this.showHitRate(this.ssHit, this.ssReq, "S-"));
                } else {
                    cst = new CachedStatement(this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
                    cst.setCacheable(true);
                    cst.setStatementListener(this);
                    cst.setOpen();
                    this.log_debug(this.pool.getName() + ": Statement cache miss [" + cst.getParametersString() + "] - " + this.showHitRate(this.ssHit, this.ssReq, "S-"));
                }
            }
        }
        list = this.ssUsed;
        synchronized (list) {
            this.ssUsed.add(cst);
        }
        return cst;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object object;
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        CachedPreparedStatement cps = null;
        if (!this.cacheP) {
            cps = new CachedPreparedStatement(sql, this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            cps.setCacheable(false);
            cps.setStatementListener(this);
            cps.setOpen();
        } else {
            object = this.ps;
            synchronized (object) {
                ++this.psReq;
                List<CachedPreparedStatement> list = this.ps.get(sql);
                if (list != null && !list.isEmpty()) {
                    Iterator<CachedPreparedStatement> it = list.iterator();
                    while (it.hasNext()) {
                        CachedPreparedStatement x = it.next();
                        x.setChecking(true);
                        if (x.getResultSetType() == resultSetType && x.getResultSetConcurrency() == resultSetConcurrency && x.getResultSetHoldability() == resultSetHoldability) {
                            cps = x;
                            it.remove();
                            break;
                        }
                        x.setChecking(false);
                    }
                    if (list.isEmpty()) {
                        this.ps.remove(sql);
                    }
                }
                if (cps != null) {
                    cps.setOpen();
                    ++this.psHit;
                    this.log_debug(this.pool.getName() + ": PreparedStatement cache hit [" + sql + "," + cps.getParametersString() + "] - " + this.showHitRate(this.psHit, this.psReq, "PS-"));
                } else {
                    cps = new CachedPreparedStatement(sql, this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                    cps.setCacheable(true);
                    cps.setStatementListener(this);
                    cps.setOpen();
                    this.log_debug(this.pool.getName() + ": PreparedStatement cache miss [" + sql + "," + cps.getParametersString() + "] - " + this.showHitRate(this.psHit, this.psReq, "PS-"));
                }
            }
        }
        object = this.psUsed;
        synchronized (object) {
            this.psUsed.add(cps);
        }
        return cps;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object object;
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        CachedCallableStatement ccs = null;
        if (!this.cacheC) {
            ccs = new CachedCallableStatement(sql, this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            ccs.setCacheable(false);
            ccs.setStatementListener(this);
            ccs.setOpen();
        } else {
            object = this.cs;
            synchronized (object) {
                ++this.csReq;
                List<CachedCallableStatement> list = this.cs.get(sql);
                if (list != null && !list.isEmpty()) {
                    Iterator<CachedCallableStatement> it = list.iterator();
                    while (it.hasNext()) {
                        CachedCallableStatement x = it.next();
                        x.setChecking(true);
                        if (x.getResultSetType() == resultSetType && x.getResultSetConcurrency() == resultSetConcurrency && x.getResultSetHoldability() == resultSetHoldability) {
                            ccs = x;
                            it.remove();
                            break;
                        }
                        x.setChecking(false);
                    }
                    if (list.isEmpty()) {
                        this.cs.remove(sql);
                    }
                }
                if (ccs != null) {
                    ccs.setOpen();
                    ++this.csHit;
                    this.log_debug(this.pool.getName() + ": CallableStatement cache hit [" + sql + "," + ccs.getParametersString() + "] - " + this.showHitRate(this.csHit, this.csReq, "CS-"));
                } else {
                    CallableStatement st = this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                    ccs = new CachedCallableStatement(sql, st);
                    ccs.setCacheable(true);
                    ccs.setStatementListener(this);
                    ccs.setOpen();
                    this.log_debug(this.pool.getName() + ": CallableStatement cache miss [" + sql + "," + ccs.getParametersString() + "] - " + this.showHitRate(this.csHit, this.csReq, "CS-"));
                }
            }
        }
        object = this.csUsed;
        synchronized (object) {
            this.csUsed.add(ccs);
        }
        return ccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statementClosed(CachedStatement s) throws SQLException {
        Object object = this.nonCacheable;
        synchronized (object) {
            if (this.nonCacheable.remove(s)) {
                s.release();
                return;
            }
        }
        if (s instanceof CachedCallableStatement) {
            object = this.cs;
            synchronized (object) {
                CachedCallableStatement ccs = (CachedCallableStatement)s;
                String key = ccs.getSQLString();
                List<CachedCallableStatement> list = this.csUsed;
                synchronized (list) {
                    this.csUsed.remove(ccs);
                }
                if (!this.cacheC || !ccs.isCacheable()) {
                    ccs.release();
                } else {
                    try {
                        ccs.recycle();
                        List<CachedCallableStatement> list2 = this.cs.get(key);
                        if (list2 == null) {
                            list2 = new ArrayList<CachedCallableStatement>();
                            this.cs.put(key, list2);
                        }
                        list2.add(ccs);
                    }
                    catch (SQLException sqlx) {
                        ccs.release();
                    }
                }
            }
        }
        if (s instanceof CachedPreparedStatement) {
            object = this.ps;
            synchronized (object) {
                CachedPreparedStatement cps = (CachedPreparedStatement)s;
                String key = cps.getSQLString();
                List<CachedPreparedStatement> sqlx = this.psUsed;
                synchronized (sqlx) {
                    this.psUsed.remove(cps);
                }
                if (!this.cacheP || !cps.isCacheable()) {
                    cps.release();
                } else {
                    try {
                        cps.recycle();
                        List<CachedPreparedStatement> list = this.ps.get(key);
                        if (list == null) {
                            list = new ArrayList<CachedPreparedStatement>();
                            this.ps.put(key, list);
                        }
                        list.add(cps);
                    }
                    catch (SQLException sqlx2) {
                        cps.release();
                    }
                }
            }
        }
        object = this.ss;
        synchronized (object) {
            List<CachedStatement> cps = this.ssUsed;
            synchronized (cps) {
                this.ssUsed.remove(s);
            }
            if (!this.cacheS || !s.isCacheable()) {
                s.release();
            } else {
                try {
                    s.recycle();
                    this.ss.add(s);
                }
                catch (SQLException sqlx) {
                    s.release();
                }
            }
        }
    }

    private String showHitRate(int hits, int reqs, String prefix) {
        return reqs == 0 ? "" : prefix + "HitRate=" + (float)hits / (float)reqs * 100.0f + "%";
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!this.open && !this.closing) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (!this.open && !this.closing) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        if (!this.open && !this.closing) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.commit();
    }

    @Override
    public void rollback() throws SQLException {
        if (!this.open && !this.closing) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() throws SQLException {
        List<CachedStatement> list;
        int count;
        if (this.cacheS) {
            int n = count = this.ssUsed != null ? this.ssUsed.size() : 0;
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Cleaning " + count + " cached Statement" + (count != 1 ? "s" : ""));
                list = this.ssUsed;
                synchronized (list) {
                    while (!this.ssUsed.isEmpty()) {
                        this.ssUsed.remove(0).close();
                    }
                }
            }
        } else {
            this.flushOpenStatements();
            this.flushSpareStatements();
        }
        if (this.cacheP) {
            int n = count = this.psUsed != null ? this.psUsed.size() : 0;
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Cleaning " + count + " cached PreparedStatement" + (count != 1 ? "s" : ""));
                list = this.psUsed;
                synchronized (list) {
                    while (!this.psUsed.isEmpty()) {
                        this.psUsed.remove(0).close();
                    }
                }
            }
        } else {
            this.flushOpenPreparedStatements();
            this.flushSparePreparedStatements();
        }
        if (this.cacheC) {
            int n = count = this.csUsed != null ? this.csUsed.size() : 0;
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Cleaning " + count + " cached CallableStatement" + (count != 1 ? "s" : ""));
                list = this.csUsed;
                synchronized (list) {
                    while (!this.csUsed.isEmpty()) {
                        this.csUsed.remove(0).close();
                    }
                }
            }
        } else {
            this.flushOpenCallableStatements();
            this.flushSpareCallableStatements();
        }
        this.flushOpenNonCacheableStatements();
        if (!this.getAutoCommit()) {
            try {
                this.rollback();
            }
            catch (SQLException sqlx) {
                this.log_warn(this.pool.getName() + ": " + sqlx.getMessage(), sqlx);
            }
            this.setAutoCommit(true);
        }
        try {
            this.clearWarnings();
        }
        catch (SQLFeatureNotSupportedException sfnsx) {
            // empty catch block
        }
        try {
            Map<String, Class<?>> tm = this.getTypeMap();
            if (tm != null) {
                tm.clear();
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isDirty() {
        return this.usedDelegate && !this.pool.isRecycleAfterDelegateUse();
    }

    @Override
    public void close() throws SQLException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.closing = true;
        this.pool.freeConnection(this);
        this.closing = false;
    }

    public int getSpareStatementCount() {
        return this.ss.size();
    }

    public int getOpenStatementCount() {
        return this.ssUsed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSparePreparedStatementCount() {
        int count = 0;
        Map<String, List<CachedPreparedStatement>> map = this.ps;
        synchronized (map) {
            Iterator<List<CachedPreparedStatement>> it = this.ps.values().iterator();
            while (it.hasNext()) {
                count += it.next().size();
            }
        }
        return count;
    }

    public int getOpenPreparedStatementCount() {
        return this.psUsed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpareCallableStatementCount() {
        int count = 0;
        Map<String, List<CachedCallableStatement>> map = this.cs;
        synchronized (map) {
            Iterator<List<CachedCallableStatement>> it = this.cs.values().iterator();
            while (it.hasNext()) {
                count += it.next().size();
            }
        }
        return count;
    }

    public int getOpenCallableStatementCount() {
        return this.csUsed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenNonCacheableStatementCount() {
        List<CachedStatement> list = this.nonCacheable;
        synchronized (list) {
            return this.nonCacheable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSpareStatements() throws SQLException {
        List<CachedStatement> list = this.ss;
        synchronized (list) {
            int count = this.ss.size();
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Closing " + count + " cached Statement" + (count != 1 ? "s" : ""));
                while (!this.ss.isEmpty()) {
                    this.ss.remove(0).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenStatements() throws SQLException {
        List<CachedStatement> list = this.ssUsed;
        synchronized (list) {
            int count = this.ssUsed.size();
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Closing " + count + " open Statement" + (count != 1 ? "s" : ""));
                while (!this.ssUsed.isEmpty()) {
                    this.ssUsed.remove(0).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSparePreparedStatements() throws SQLException {
        Map<String, List<CachedPreparedStatement>> map = this.ps;
        synchronized (map) {
            int count = this.ps.size();
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Closing " + count + " cached PreparedStatement" + (count != 1 ? "s" : ""));
                for (List<CachedPreparedStatement> list : this.ps.values()) {
                    for (CachedPreparedStatement cps : list) {
                        cps.release();
                    }
                }
                this.ps.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenPreparedStatements() throws SQLException {
        List<CachedPreparedStatement> list = this.psUsed;
        synchronized (list) {
            int count = this.psUsed.size();
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Closing " + count + " open PreparedStatement" + (count != 1 ? "s" : ""));
                while (!this.psUsed.isEmpty()) {
                    this.psUsed.remove(0).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSpareCallableStatements() throws SQLException {
        Map<String, List<CachedCallableStatement>> map = this.cs;
        synchronized (map) {
            int count = this.cs.size();
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Closing " + count + " cached CallableStatement" + (count != 1 ? "s" : ""));
                for (List<CachedCallableStatement> list : this.cs.values()) {
                    for (CachedCallableStatement ccs : list) {
                        ccs.release();
                    }
                }
                this.cs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenCallableStatements() throws SQLException {
        List<CachedCallableStatement> list = this.csUsed;
        synchronized (list) {
            int count = this.csUsed.size();
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Closing " + count + " open CallableStatement" + (count != 1 ? "s" : ""));
                while (!this.csUsed.isEmpty()) {
                    this.csUsed.remove(0).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenNonCacheableStatements() throws SQLException {
        List<CachedStatement> list = this.nonCacheable;
        synchronized (list) {
            int count = this.nonCacheable.size();
            if (count > 0) {
                this.log_debug(this.pool.getName() + ": Closing " + count + " open non-cacheable Statement" + (count != 1 ? "s" : ""));
                while (!this.nonCacheable.isEmpty()) {
                    try {
                        ((Statement)this.nonCacheable.remove(0)).close();
                    }
                    catch (SQLException sqlx) {
                        this.logger.warn(this.pool.getName() + ": " + sqlx.getMessage(), (Throwable)sqlx);
                    }
                }
            }
        }
    }

    public void release() throws SQLException {
        this.open = false;
        ArrayList<SQLException> list = new ArrayList<SQLException>();
        try {
            this.flushSpareStatements();
            this.flushOpenStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.flushSparePreparedStatements();
            this.flushOpenPreparedStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.flushSpareCallableStatements();
            this.flushOpenCallableStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.flushOpenNonCacheableStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.con.close();
        }
        catch (SQLException e) {
            list.add(e);
        }
        if (!list.isEmpty()) {
            SQLException sqle = new SQLException("Problem releasing connection resources");
            for (SQLException x : list) {
                sqle.setNextException(x);
                sqle = x;
            }
            throw sqle;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (!this.open && !this.closing) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (!this.open && !this.closing) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (!this.open && !this.closing) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.releaseSavepoint(savepoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        CachedPreparedStatement x = new CachedPreparedStatement(sql, this.con.prepareStatement(sql, autoGeneratedKeys));
        x.setCacheable(false);
        x.setStatementListener(this);
        List<CachedStatement> list = this.nonCacheable;
        synchronized (list) {
            this.nonCacheable.add(x);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        CachedPreparedStatement x = new CachedPreparedStatement(sql, this.con.prepareStatement(sql, columnIndexes));
        x.setCacheable(false);
        x.setStatementListener(this);
        List<CachedStatement> list = this.nonCacheable;
        synchronized (list) {
            this.nonCacheable.add(x);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        CachedPreparedStatement x = new CachedPreparedStatement(sql, this.con.prepareStatement(sql, columnNames));
        x.setCacheable(false);
        x.setStatementListener(this);
        List<CachedStatement> list = this.nonCacheable;
        synchronized (list) {
            this.nonCacheable.add(x);
        }
        return x;
    }

    public Connection getConnection() throws SQLException {
        return this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.con);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            T x = iface.cast(this.con);
            this.usedDelegate = true;
            return x;
        }
        catch (ClassCastException ccx) {
            throw new SQLException("Invalid type specified for unwrap operation: " + iface.getName(), ccx);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.con.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.con.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        this.con.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (!this.open) {
            throw new SQLException(MSG_CONNECTION_CLOSED);
        }
        return this.con.getNetworkTimeout();
    }
}

