/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class LogUtil {
    private DateFormat dateFormat;
    private DateFormat ddf;
    private PrintWriter logWriter;
    private boolean logging = false;
    private boolean closeWriterOnExit = true;
    private String separator = ": ";
    private boolean debug = false;

    public LogUtil() {
    }

    public LogUtil(File file) throws IOException {
        this.setLog(new PrintWriter(new FileOutputStream(file, true), true));
    }

    public synchronized void setDateFormat(DateFormat df) {
        this.dateFormat = df;
    }

    public synchronized void setSeparator(String sep) {
        this.separator = sep == null ? ": " : sep;
    }

    public final synchronized void setLog(PrintWriter writer) {
        this.setLog(writer, true);
    }

    public synchronized void setLog(PrintWriter writer, boolean closeOnExit) {
        if (this.logWriter != null) {
            this.logWriter.flush();
            if (this.closeWriterOnExit) {
                this.close();
            }
        }
        this.logging = writer != null;
        this.logWriter = this.logging ? writer : null;
        this.closeWriterOnExit = this.logWriter != null ? closeOnExit : false;
    }

    public synchronized PrintWriter getLogWriter() {
        return this.logWriter;
    }

    protected synchronized void writeLogEntry(String logEntry) {
        if (!this.logging) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Date date = new Date();
        if (this.dateFormat != null) {
            sb.append(this.dateFormat.format(date));
        } else {
            if (this.ddf == null) {
                this.ddf = DateFormat.getDateTimeInstance(1, 1);
            }
            sb.append(this.ddf.format(date));
        }
        if (this.separator != null) {
            sb.append(this.separator);
        }
        sb.append(logEntry);
        this.logWriter.println(sb.toString());
    }

    public synchronized void debug(String logEntry) {
        if (this.isDebug()) {
            this.writeLogEntry(logEntry);
        }
    }

    public synchronized void debug(String prefix, String logEntry) {
        if (this.isDebug()) {
            this.log(prefix, logEntry);
        }
    }

    public void debug(String logEntry, Throwable throwable) {
        if (this.isDebug()) {
            this.log(logEntry, throwable);
        }
    }

    public synchronized void log(String logEntry) {
        this.writeLogEntry(logEntry);
    }

    public synchronized void log(String prefix, String logEntry) {
        if (prefix == null || prefix.equals("")) {
            this.writeLogEntry(logEntry);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            sb.append(logEntry);
            this.writeLogEntry(sb.toString());
        }
    }

    public synchronized void log(String prefix, String logEntry, Throwable throwable) {
        if (!this.logging) {
            return;
        }
        if (prefix == null || prefix.equals("")) {
            this.log(logEntry, throwable);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            sb.append(logEntry);
            this.log(sb.toString(), throwable);
        }
    }

    public synchronized void log(String logEntry, Throwable throwable) {
        if (!this.logging) {
            return;
        }
        this.writeLogEntry(logEntry);
        if (throwable != null) {
            throwable.printStackTrace(this.logWriter);
            this.logWriter.flush();
        }
    }

    public void log(Throwable throwable) {
        this.log(throwable.getMessage(), throwable);
    }

    public synchronized void close() {
        this.logging = false;
        if (this.logWriter != null) {
            this.logWriter.flush();
            if (this.closeWriterOnExit) {
                this.logWriter.close();
            }
        }
        this.logWriter = null;
    }

    public synchronized void setLogging(boolean b) {
        this.logging = b;
    }

    public synchronized boolean isLogging() {
        return this.logging;
    }

    public synchronized void setDebug(boolean b) {
        this.debug = b;
    }

    public synchronized boolean isDebug() {
        return this.debug;
    }
}

