/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import snaq.db.ConnectionPoolManager;

public class SQLUpdate
implements AutoCloseable {
    protected static final Logger logger = LoggerFactory.getLogger(SQLUpdate.class);
    private ConnectionPoolManager cpm;
    private Connection con;
    private Statement statement;

    public SQLUpdate(String poolname) throws IOException, SQLException {
        this.cpm = ConnectionPoolManager.getInstance();
        this.openConnection(poolname);
    }

    public SQLUpdate(Connection con) throws SQLException {
        this.openConnection(con);
    }

    private void openConnection(Connection con) throws SQLException {
        if (con == null || con.isClosed()) {
            throw new IllegalArgumentException("Please specify a valid connection");
        }
        try {
            this.con = con;
            this.statement = con.createStatement();
        }
        catch (SQLException sqlx) {
            try {
                this.statement.close();
            }
            catch (SQLException sqlx2) {
                // empty catch block
            }
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void openConnection(String poolname) throws SQLException {
        if (poolname == null || poolname.equals("")) {
            throw new IllegalArgumentException("Please specify the name of a defined connection pool");
        }
        try {
            this.con = this.cpm.getConnection(poolname);
            this.statement = this.con.createStatement();
        }
        catch (SQLException sqlx) {
            try {
                this.statement.close();
            }
            catch (SQLException sqlx2) {
                // empty catch block
            }
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        try {
            this.statement.close();
        }
        catch (SQLException sqlx) {
            sqlx.printStackTrace();
        }
        try {
            this.con.close();
        }
        catch (SQLException sqlx) {
            sqlx.printStackTrace();
        }
        if (this.cpm != null) {
            this.cpm.release();
        }
    }

    public void doStatement(String sql) throws SQLException {
        try {
            logger.trace(sql);
            this.statement.executeUpdate(sql);
        }
        catch (SQLException sqlx) {
            logger.info(sqlx.getMessage(), (Throwable)sqlx);
            throw sqlx;
        }
    }

    /*
     * Exception decompiling
     */
    public static final String loadTextFile(File f) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String[] splitSQL(String text, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (separator == null) {
            StringTokenizer st = new StringTokenizer(text, "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("#") || "".equals(token)) continue;
                list.add(token);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(text, "\n\r");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.startsWith("#") || line.startsWith("--")) {
                    sb.setLength(0);
                    continue;
                }
                int pos = line.indexOf(separator);
                if (pos >= 0) {
                    sb.append(line.substring(0, pos));
                    list.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(line);
            }
        }
        return list.toArray(new String[0]);
    }

    public static void main(String[] args) throws Exception {
        String separator;
        String cn = SQLUpdate.class.getName();
        if (args == null || args.length < 2) {
            System.out.println("Usage: java " + cn + " <poolname> <text file> [<separator>]");
            System.exit(0);
        }
        String poolName = args[0];
        String file = args[1];
        String string = separator = args.length < 3 ? null : args[2];
        if (separator != null) {
            System.out.println("Separator: " + separator);
        }
        String contents = null;
        try {
            contents = SQLUpdate.loadTextFile(new File(file));
        }
        catch (IOException iox) {
            System.out.println("I/O error with file " + file);
            iox.printStackTrace();
            System.exit(1);
        }
        String[] sql = SQLUpdate.splitSQL(contents, separator);
        try (SQLUpdate sqlUpdate = new SQLUpdate(poolName);){
            for (String s : sql) {
                sqlUpdate.doStatement(s);
            }
        }
        catch (IOException iox) {
            System.err.println("Unable to create instance of " + cn);
            iox.printStackTrace();
            System.exit(1);
        }
        catch (SQLException sqlx) {
            sqlx.printStackTrace();
        }
        System.out.println();
    }
}

