/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import snaq.db.CacheConnection;
import snaq.db.ConnectionPool;
import snaq.db.ConnectionPoolListener;
import snaq.db.ConnectionPoolManagerEvent;
import snaq.db.ConnectionPoolManagerListener;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.db.SimpleQueryValidator;
import snaq.util.ObjectPool;
import snaq.util.ObjectPoolListener;
import snaq.util.logging.LogUtil;

public final class ConnectionPoolManager
implements Comparable<ConnectionPoolManager> {
    private static Logger logShared = LoggerFactory.getLogger(ConnectionPoolManager.class);
    private Logger logger;
    private LogUtil logUtil;
    private static final String PROPERTIES_INSTANCE_KEY = "PROPERTIES_INSTANCE";
    static final String DEFAULT_PROPERTIES_FILE = "/dbpool.properties";
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private static HashMap<Object, ConnectionPoolManager> managers = new HashMap();
    private Set<Driver> drivers = new HashSet<Driver>();
    private String name;
    private static int unnamedCount = 0;
    private static Thread shutdownHookGlobal = null;
    private Thread shutdownHook = null;
    private boolean released = false;
    private final Map<String, ConnectionPool> pools = new HashMap<String, ConnectionPool>();
    private Object source;
    private Object instanceKey;
    private final List<ConnectionPoolManagerListener> listeners = new ArrayList<ConnectionPoolManagerListener>();

    private ConnectionPoolManager(Properties props, Object src) {
        this.source = src;
        this.init(props);
    }

    public synchronized void registerShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        try {
            this.shutdownHook = new Releaser(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Exception ex) {
            this.log_warn("Error registering shutdown-hook for " + this, ex);
        }
    }

    public synchronized void removeShutdownHook() {
        try {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.shutdownHook = null;
            this.log_info("Removed ConnectionPoolManager shutdown-hook");
        }
        catch (Exception ex) {
            this.log_warn("Error removing ConnectionPoolManager shutdown-hook", ex);
        }
    }

    public static synchronized void registerGlobalShutdownHook() {
        if (shutdownHookGlobal != null) {
            return;
        }
        try {
            shutdownHookGlobal = new Releaser();
            Runtime.getRuntime().addShutdownHook(shutdownHookGlobal);
            logShared.info("Registered global ConnectionPoolManager shutdown-hook");
            for (ConnectionPoolManager cpm : ConnectionPoolManager.getInstances()) {
                cpm.removeShutdownHook();
            }
        }
        catch (Exception ex) {
            logShared.warn("Error registering global ConnectionPoolManager shutdown-hook", (Throwable)ex);
        }
    }

    public static void removeGlobalShutdownHook() {
        if (shutdownHookGlobal != null) {
            Runtime.getRuntime().removeShutdownHook(shutdownHookGlobal);
        }
        shutdownHookGlobal = null;
        logShared.info("Removed global ConnectionPoolManager shutdown-hook");
    }

    public String toString() {
        if (this.source instanceof String) {
            return this.getClass().getName() + "[CLASSPATH resource:" + this.source + "]";
        }
        if (this.source instanceof File) {
            return this.getClass().getName() + "[File:" + ((File)this.source).getAbsolutePath() + "]";
        }
        if (this.source instanceof Properties) {
            return this.getClass().getName() + "[Properties]";
        }
        return this.getClass().getName() + "[Unknown]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionPoolManager other = (ConnectionPoolManager)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.source == other.source || this.source != null && this.source.equals(other.source);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 71 * hash + (this.toString() != null ? this.toString().hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(ConnectionPoolManager cpm) {
        if (cpm == null) {
            throw new NullPointerException("Invalid pool manager specified: null");
        }
        int i = this.name.compareTo(cpm.getName());
        if (i != 0) {
            return i;
        }
        if (this.source instanceof String) {
            i = ((String)this.source).compareTo((String)cpm.source);
        } else if (this.source instanceof File) {
            i = ((File)this.source).compareTo((File)cpm.source);
        } else if (this.source instanceof Properties) {
            Properties p1 = (Properties)this.source;
            Properties p2 = (Properties)cpm.source;
            i = Integer.valueOf(p2.size()).compareTo(p1.size());
        }
        return i;
    }

    public static Set<ConnectionPoolManager> getInstances() {
        return new HashSet<ConnectionPoolManager>(managers.values());
    }

    public static synchronized ConnectionPoolManager getInstance(String propsFile, String enc) throws IOException {
        ConnectionPoolManager cpm;
        if (propsFile == null) {
            throw new NullPointerException("Invalid value for propsFile specified: null");
        }
        String s = propsFile.startsWith("/") ? propsFile : "/" + propsFile;
        ConnectionPoolManager o = managers.get(s);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? o : null;
        if (cpm == null || cpm.isReleased()) {
            Properties props = ConnectionPoolManager.loadProperties(s, enc);
            if (props == null) {
                throw new FileNotFoundException("Unable to find properties file: " + propsFile);
            }
            cpm = new ConnectionPoolManager(props, propsFile);
            cpm.instanceKey = s;
            managers.put(cpm.instanceKey, cpm);
            cpm.fireInstancesChangedEvent();
        }
        return cpm;
    }

    public static synchronized ConnectionPoolManager getInstance(String propsFile) throws IOException {
        return ConnectionPoolManager.getInstance(propsFile, DEFAULT_CHARSET);
    }

    public static synchronized ConnectionPoolManager getInstance(File propsFile, String enc) throws IOException {
        ConnectionPoolManager cpm;
        ConnectionPoolManager o = managers.get(propsFile);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? o : null;
        if (cpm == null || cpm.isReleased()) {
            try {
                cpm = new ConnectionPoolManager(ConnectionPoolManager.loadProperties(propsFile, enc), propsFile);
                cpm.instanceKey = propsFile;
                managers.put(cpm.instanceKey, cpm);
                cpm.fireInstancesChangedEvent();
            }
            catch (IOException iox) {
                if (iox instanceof FileNotFoundException) {
                    logShared.warn("Unable to find the properties file " + propsFile.getAbsolutePath(), (Throwable)iox);
                } else {
                    logShared.warn("Error loading the properties file " + propsFile.getAbsolutePath(), (Throwable)iox);
                }
                return null;
            }
        }
        return cpm;
    }

    public static synchronized ConnectionPoolManager getInstance(File propsFile) throws IOException {
        return ConnectionPoolManager.getInstance(propsFile, DEFAULT_CHARSET);
    }

    public static synchronized ConnectionPoolManager getInstance() throws IOException {
        ConnectionPoolManager cpm;
        ConnectionPoolManager o = managers.get(PROPERTIES_INSTANCE_KEY);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? o : null;
        if (cpm == null || cpm.isReleased()) {
            cpm = ConnectionPoolManager.getInstance(DEFAULT_PROPERTIES_FILE);
        }
        return cpm;
    }

    public static synchronized void createInstance(Properties props) {
        ConnectionPoolManager cpm;
        ConnectionPoolManager o = managers.get(DEFAULT_PROPERTIES_FILE);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? o : null;
        if (cpm != null && !cpm.isReleased()) {
            throw new IllegalStateException("Default properties file instance already exists");
        }
        cpm = new ConnectionPoolManager(props, props);
        cpm.instanceKey = PROPERTIES_INSTANCE_KEY;
        managers.put(cpm.instanceKey, cpm);
        cpm.fireInstancesChangedEvent();
    }

    private static Properties loadProperties(File propsFile, String enc) throws IOException {
        if (!propsFile.exists()) {
            throw new FileNotFoundException(propsFile.getAbsolutePath() + " does not exist");
        }
        if (propsFile.isDirectory()) {
            throw new IOException("Error accessing properties file - " + propsFile.getAbsolutePath() + " is a directory");
        }
        FileInputStream is = new FileInputStream(propsFile);
        Properties props = null;
        try {
            props = ConnectionPoolManager.loadProperties(is, enc);
        }
        catch (IOException iox) {
            logShared.warn("Unable to find the properties file " + propsFile.getAbsolutePath(), (Throwable)iox);
            throw iox;
        }
        return props;
    }

    static Properties loadProperties(String propsResource) throws IOException {
        return ConnectionPoolManager.loadProperties(propsResource, DEFAULT_CHARSET);
    }

    static Properties loadProperties(String propsResource, String enc) throws IOException {
        InputStream is = ConnectionPoolManager.class.getResourceAsStream(propsResource);
        if (is == null) {
            throw new FileNotFoundException("Unable to find properties file: " + propsResource);
        }
        Properties props = null;
        try {
            props = ConnectionPoolManager.loadProperties(is, enc);
        }
        catch (IOException iox) {
            logShared.warn("Unable to load the properties file. Make sure " + propsResource + " is in the CLASSPATH.", (Throwable)iox);
            throw iox;
        }
        return props;
    }

    private static Properties loadProperties(InputStream is, String enc) throws IOException {
        Properties props = new Properties();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, enc));){
            String line = null;
            while ((line = br.readLine()) != null) {
                int epos;
                if (line.trim().startsWith("#") || (epos = line.indexOf(61)) <= 0) continue;
                String string = line.substring(0, epos).trim();
                String val = line.substring(epos + 1).trim();
                props.setProperty(string, val);
            }
        }
        logShared.info("Loaded ConnectionPoolManager properties with encoding " + enc);
        if (logShared.isTraceEnabled()) {
            String LSEP = System.getProperty("line.separator");
            TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
            StringBuilder sb = new StringBuilder();
            sb.append("Properties read:");
            sb.append(LSEP);
            for (Object e : keys) {
                String key = (String)e;
                sb.append('\t');
                sb.append(key);
                sb.append('=');
                sb.append(props.getProperty(key));
                sb.append(LSEP);
            }
            logShared.trace(sb.toString());
        }
        return props;
    }

    private static Properties processProperties(Properties props) {
        Properties propsP = new Properties();
        Pattern dp = Pattern.compile("^([^.]+)(\\.prop\\.)(.+)$", 2);
        Pattern pp = Pattern.compile("^([^.]+)((?:\\.[^.]+)+)$");
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String newkey = null;
            Matcher mdp = dp.matcher(key);
            Matcher matcher = pp.matcher(key);
            if (mdp.matches()) {
                newkey = mdp.group(1) + mdp.group(2).toLowerCase() + mdp.group(3);
            } else if (matcher.matches()) {
                newkey = matcher.group(1).toLowerCase() + matcher.group(2).toLowerCase();
            }
            if (newkey != null && !key.equals(newkey)) {
                propsP.put(newkey, props.getProperty(key));
                continue;
            }
            propsP.put(key, props.getProperty(key));
        }
        if (logShared.isTraceEnabled()) {
            String LSEP = System.getProperty("line.separator");
            TreeSet<Object> keys = new TreeSet<Object>(propsP.keySet());
            StringBuilder sb = new StringBuilder();
            sb.append("Properties processed:");
            sb.append(LSEP);
            for (Object e2 : keys) {
                String key = (String)e2;
                sb.append('\t');
                sb.append(key);
                sb.append('=');
                sb.append(propsP.getProperty(key));
                sb.append(LSEP);
            }
            logShared.trace(sb.toString());
        }
        return propsP;
    }

    private void init(Properties p) {
        Properties props = ConnectionPoolManager.processProperties(p);
        this.name = props.getProperty("name");
        if (this.name == null || this.name.equals("")) {
            this.name = "unknown" + unnamedCount++;
        }
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + this.name));
        String logFile = props.getProperty("logfile");
        String df = props.getProperty("dateformat");
        if (logFile != null) {
            try {
                this.logUtil = new LogUtil(new File(logFile));
                if (df != null) {
                    this.logUtil.setDateFormat(new SimpleDateFormat(df));
                } else {
                    this.logUtil.setDateFormat(DateFormat.getDateTimeInstance(1, 1));
                }
            }
            catch (IOException e) {
                System.err.println("Can't open the log file: " + logFile);
            }
        }
        this.loadDrivers(props);
        this.createPools(props);
    }

    private void loadDrivers(Properties props) {
        String driverClasses = props.getProperty("drivers");
        StringTokenizer st = new StringTokenizer(driverClasses, ",: \t\n\r\f");
        Enumeration<Driver> current = DriverManager.getDrivers();
        while (st.hasMoreElements()) {
            String driverClassName = st.nextToken().trim();
            try {
                boolean using = false;
                while (current.hasMoreElements()) {
                    String cName = current.nextElement().getClass().getName();
                    if (!cName.equals(driverClassName)) continue;
                    using = true;
                }
                if (using) continue;
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
                this.drivers.add(driver);
                this.log_info("Registered JDBC driver " + driverClassName);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException ex) {
                this.log_warn("Unable to register JDBC driver: " + driverClassName, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void createPools(Properties props) {
        for (String string : props.keySet()) {
            Object o;
            void var27_31;
            int idleTimeout;
            int maxSize;
            int maxPool;
            String validator;
            String pIdleTimeout;
            if (!string.endsWith(".url")) continue;
            String poolName = string.substring(0, string.lastIndexOf("."));
            String url = props.getProperty(string);
            if (url == null || "".equals(url.trim())) {
                this.log_warn("No URL specified for " + poolName);
                continue;
            }
            String user = props.getProperty(poolName + ".user");
            user = user != null ? user.trim() : user;
            String pass = props.getProperty(poolName + ".password");
            pass = pass != null ? pass.trim() : pass;
            String pMinPool = props.getProperty(poolName + ".minpool", "0").trim();
            String pMaxPool = props.getProperty(poolName + ".maxpool", "0").trim();
            String pMaxSize = props.getProperty(poolName + ".maxsize");
            if (pMaxSize != null) {
                pMaxSize = pMaxSize.trim();
            }
            if ((pIdleTimeout = props.getProperty(poolName + ".idletimeout")) != null) {
                pIdleTimeout = pIdleTimeout.trim();
            }
            validator = (validator = props.getProperty(poolName + ".validator")) != null ? validator.trim() : validator;
            String validatorQuery = props.getProperty(poolName + ".validatorQuery");
            validatorQuery = validatorQuery != null ? validatorQuery.trim() : validatorQuery;
            String decoder = props.getProperty(poolName + ".decoder");
            String pInit = props.getProperty(poolName + ".init", "0").trim();
            boolean noCache = props.getProperty(poolName + ".cache", "true").trim().equalsIgnoreCase("false");
            String selection = props.getProperty(poolName + ".selection");
            boolean async = props.getProperty(poolName + ".async", "false").trim().equalsIgnoreCase("true");
            boolean recycleAfterDelegateUse = props.getProperty(poolName + ".recycleafterdelegateuse", "false").trim().equalsIgnoreCase("true");
            boolean mbean = props.getProperty(poolName + ".mbean", "false").trim().equalsIgnoreCase("true");
            String logFile = props.getProperty(poolName + ".logfile");
            String dateformat = props.getProperty(poolName + ".dateformat");
            boolean poolDebug = props.getProperty(poolName + ".debug", "false").trim().equalsIgnoreCase("true");
            Properties poolProps = new Properties();
            String prefix = poolName + ".prop.";
            for (String string2 : props.keySet()) {
                if (!string2.startsWith(prefix)) continue;
                poolProps.setProperty(string2.substring(prefix.length()), props.getProperty(string2));
            }
            if (!poolProps.isEmpty() && user != null && !"".equals(user)) {
                poolProps.setProperty("user", user);
                poolProps.setProperty("password", pass);
            } else {
                poolProps = null;
            }
            try {
                int n = Integer.parseInt(pMinPool);
            }
            catch (NumberFormatException nfx) {
                this.log_warn("Invalid minpool value " + pMinPool + " for " + poolName);
                boolean bl = false;
            }
            try {
                maxPool = Integer.parseInt(pMaxPool);
            }
            catch (NumberFormatException nfx) {
                this.log_warn("Invalid maxpool value " + pMaxPool + " for " + poolName);
                maxPool = 0;
            }
            try {
                maxSize = Integer.parseInt(pMaxSize);
            }
            catch (NumberFormatException nfx) {
                this.log_warn("Invalid maxsize value " + pMaxSize + " for " + poolName);
                maxSize = 0;
            }
            int initSize = 0;
            try {
                initSize = Integer.parseInt(pInit);
            }
            catch (NumberFormatException nfx) {
                this.log_warn("Invalid init value " + pInit + " for " + poolName);
                initSize = 0;
            }
            try {
                idleTimeout = Integer.parseInt(pIdleTimeout);
            }
            catch (NumberFormatException nfx) {
                this.log_warn("Invalid idleTimeout value " + pIdleTimeout + " for " + poolName);
                idleTimeout = 0;
            }
            int n = Math.max((int)var27_31, 0);
            maxPool = Math.max(maxPool, 0);
            maxSize = Math.max(maxSize, 0);
            if (maxSize > 0) {
                maxSize = Math.max(maxSize, maxPool);
            }
            idleTimeout = Math.max(idleTimeout, 0);
            ConnectionPool pool = null;
            pool = poolProps != null ? new ConnectionPool(poolName, n, maxPool, maxSize, idleTimeout, url, poolProps) : new ConnectionPool(poolName, n, maxPool, maxSize, idleTimeout, url, user, pass);
            if (mbean) {
                pool.registerMBean();
            }
            if (logFile != null && !"".equals(logFile)) {
                try {
                    File f = new File(logFile);
                    if (f.isDirectory()) {
                        this.log_warn("Invalid logfile specified for pool " + poolName + " - specified file is a directory");
                    } else if (!f.exists() && !f.createNewFile()) {
                        this.log_warn("Invalid logfile specified for pool " + poolName + " - cannot create file " + f.getAbsolutePath());
                    }
                    pool.setLog(new PrintWriter(new FileOutputStream(f, true), true));
                }
                catch (IOException iox) {
                    this.log_warn("Invalid logfile specified for pool " + poolName, iox);
                    if (this.logUtil != null) {
                        pool.setLog(this.logUtil.getLogWriter());
                    }
                }
            } else if (this.logUtil != null) {
                pool.setLog(this.logUtil.getLogWriter());
            }
            if (poolDebug) {
                this.log_info("Enabling debug info on pool " + poolName);
            }
            if (this.logUtil != null) {
                this.logUtil.setDebug(poolDebug);
            }
            if (dateformat != null && !"".equals(dateformat)) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat(dateformat);
                    pool.getCustomLogger().setDateFormat(df);
                }
                catch (Exception ex) {
                    this.log_warn("Invalid dateformat string specified: " + dateformat);
                }
            }
            if (noCache) {
                this.log_info("Disabling caching on pool " + poolName);
            }
            pool.setCaching(!noCache);
            if (async) {
                this.log_info("Enabling asynchronous destruction on pool " + poolName);
            }
            pool.setAsyncDestroy(async);
            if (recycleAfterDelegateUse) {
                this.log_info("Enabling recycling after raw connection use on pool " + poolName);
            }
            pool.setRecycleAfterDelegateUse(recycleAfterDelegateUse);
            if (selection != null && !"".equals(selection)) {
                try {
                    if (selection.equalsIgnoreCase("RANDOM")) {
                        pool.setSelectionStrategy(ObjectPool.Strategy.SELECT_RANDOM);
                    } else if (selection.equalsIgnoreCase("FIFO")) {
                        pool.setSelectionStrategy(ObjectPool.Strategy.SELECT_FIFO);
                    }
                }
                catch (Exception ex) {
                    this.log_warn("Invalid access string specified: " + selection);
                }
            }
            if (validator != null && !"".equals(validator)) {
                try {
                    o = Class.forName(validator).newInstance();
                    if (o instanceof ConnectionValidator) {
                        pool.setValidator((ConnectionValidator)o);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    this.log_warn("Unable to instantiate validator class for pool " + poolName + ": " + validator, ex);
                }
            } else if (validatorQuery != null && !"".equals(validatorQuery)) {
                pool.setValidator(new SimpleQueryValidator(validatorQuery.trim()));
                if (validatorQuery.matches("^\\s*UPDATE")) {
                    this.log_warn("Warning; UPDATE validation query detected: " + validatorQuery);
                } else if (!validatorQuery.matches("^\\s*SELECT")) {
                    this.log_warn("Caution; non-SELECT validation query detected: " + validatorQuery);
                }
            }
            if (decoder != null && !"".equals(decoder)) {
                try {
                    o = Class.forName(decoder).newInstance();
                    if (o instanceof PasswordDecoder) {
                        pool.setPasswordDecoder((PasswordDecoder)o);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    this.log_warn("Unable to instantiate password decoder class for pool " + poolName + ": " + decoder, ex);
                }
            }
            Map<String, ConnectionPool> ex = this.pools;
            synchronized (ex) {
                this.pools.put(poolName, pool);
            }
            String info = null;
            ConnectionPool connectionPool = pool;
            synchronized (connectionPool) {
                info = "minpool=" + pool.getMinPool() + ",maxpool=" + pool.getMaxPool() + ",maxsize=" + pool.getMaxSize() + ",idleTimeout=";
                info = info + (pool.getIdleTimeout() == 0L ? "none" : Long.valueOf(pool.getIdleTimeout()));
            }
            this.log_info("Created pool " + poolName + " (" + info + ")");
            Collection<ObjectPoolListener<CacheConnection>> poolListeners = this.parseListeners(props, poolName);
            for (ObjectPoolListener<CacheConnection> x : poolListeners) {
                if (x instanceof ConnectionPoolListener) {
                    pool.addConnectionPoolListener((ConnectionPoolListener)((Object)x));
                    continue;
                }
                pool.addObjectPoolListener(x);
            }
            if (initSize > 0 && props.getProperty(poolName + ".minpool") == null) {
                pool.init(initSize);
                continue;
            }
            pool.init();
        }
    }

    private Collection<ObjectPoolListener<CacheConnection>> parseListeners(Properties props, String poolName) {
        ArrayList<ObjectPoolListener<CacheConnection>> poolListeners = new ArrayList<ObjectPoolListener<CacheConnection>>();
        String noPropListeners = props.getProperty(poolName + ".listeners");
        if (noPropListeners != null && !"".equals(noPropListeners)) {
            StringTokenizer st = new StringTokenizer(noPropListeners, ",: \t\n\r\f");
            while (st.hasMoreTokens()) {
                String x = st.nextToken();
                try {
                    Object o = Class.forName(x).newInstance();
                    if (!(o instanceof ObjectPoolListener)) continue;
                    poolListeners.add((ObjectPoolListener)o);
                    this.log_trace("Added no-property PoolListener: " + x);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    this.log_warn("Unable to instantiate listener class for pool " + poolName + ": " + x, ex);
                }
            }
        }
        int count = 0;
        String propListener = props.getProperty(poolName + ".listener" + count);
        while (propListener != null && !propListener.trim().equals("")) {
            block18: {
                try {
                    Class<?> c = Class.forName(propListener);
                    if (ObjectPoolListener.class.isAssignableFrom(c)) {
                        Constructor<?> conP = null;
                        Constructor<?> conB = null;
                        try {
                            conP = c.getConstructor(Properties.class);
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                        try {
                            conB = c.getConstructor(new Class[0]);
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                        Properties lp = new Properties();
                        if (conP != null) {
                            String prefix = poolName + ".listener" + count + ".";
                            Enumeration<?> e = props.propertyNames();
                            while (e.hasMoreElements()) {
                                String propKey = (String)e.nextElement();
                                if (!propKey.startsWith(prefix)) continue;
                                lp.setProperty(propKey.substring(prefix.length()), props.getProperty(propKey));
                            }
                        }
                        if (conP != null && conB == null || conP != null && conB != null && !lp.isEmpty()) {
                            poolListeners.add((ObjectPoolListener<CacheConnection>)conP.newInstance(lp));
                        } else if (conB != null) {
                            poolListeners.add((ObjectPoolListener<CacheConnection>)conB.newInstance(new Object[0]));
                        } else {
                            this.log_warn("Unable to instantiate listener class for pool " + poolName + ": " + propListener);
                        }
                        break block18;
                    }
                    this.log_warn("Listener class specified is not a valid listener: " + propListener);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
                    this.log_warn("Unable to instantiate listener class for pool " + poolName + ": " + propListener, ex.getCause());
                }
            }
            propListener = props.getProperty(poolName + ".listener" + ++count);
        }
        return poolListeners;
    }

    private static Properties compareProperties(Properties p1, Properties p2) {
        Properties dp = new Properties();
        Enumeration<?> e = p2.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String p2v = p2.getProperty(key);
            if (p1.containsKey(key)) {
                if (p2v.equals(p1.getProperty(key))) continue;
                dp.setProperty(key, p2v);
                continue;
            }
            dp.setProperty(key, p2v);
        }
        return dp;
    }

    public final String getName() {
        return this.name;
    }

    public ConnectionPool getPool(String name) {
        if (this.released) {
            throw new IllegalStateException("Pool manager no longer valid for use");
        }
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Invalid pool name specified: " + name);
        }
        return this.pools.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ConnectionPool> getPools() {
        Map<String, ConnectionPool> map = this.pools;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.pools.values());
        }
    }

    public Connection getConnection(String name) throws SQLException {
        if (this.released) {
            throw new IllegalStateException("Pool manager no longer valid for use");
        }
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Invalid pool name specified: " + name);
        }
        ConnectionPool pool = this.pools.get(name);
        if (pool == null) {
            throw new IllegalArgumentException("Pool " + name + " not found");
        }
        return pool.getConnection();
    }

    public Connection getConnection(String name, long timeout) throws SQLException {
        if (this.released) {
            throw new IllegalStateException("Pool manager no longer valid for use");
        }
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Invalid pool name specified: " + name);
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout value specified: " + timeout);
        }
        ConnectionPool pool = this.pools.get(name);
        if (pool == null) {
            throw new IllegalArgumentException("Pool " + name + " not found");
        }
        return pool.getConnection(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        if (this.isReleased()) {
            return;
        }
        this.released = true;
        Map<String, ConnectionPool> map = this.pools;
        synchronized (map) {
            for (ConnectionPool pool : this.pools.values()) {
                pool.releaseForcibly();
            }
        }
        for (ConnectionPoolManager cpm : managers.values()) {
            if (cpm.equals(this)) continue;
            this.drivers.removeAll(cpm.drivers);
        }
        for (Driver driver : this.drivers) {
            try {
                DriverManager.deregisterDriver(driver);
                this.log_info("Deregistered JDBC driver " + driver.getClass().getName());
            }
            catch (SQLException sqlx) {
                this.log_warn("Unable to deregister JDBC driver: " + driver.getClass().getName(), sqlx);
            }
        }
        managers.remove(this.instanceKey);
        this.fireReleasedEvent();
        this.fireInstancesChangedEvent();
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    protected void log_error(String s) {
        String msg = this.name + ": " + s;
        this.logger.error(msg);
        if (this.logUtil != null) {
            this.logUtil.log(msg);
        }
    }

    protected void log_error(String s, Throwable throwable) {
        String msg = this.name + ": " + s;
        this.logger.error(msg, throwable);
        if (this.logUtil != null) {
            this.logUtil.log(msg, throwable);
        }
    }

    protected void log_warn(String s) {
        String msg = this.name + ": " + s;
        this.logger.warn(msg);
        if (this.logUtil != null) {
            this.logUtil.log(msg);
        }
    }

    protected void log_warn(String s, Throwable throwable) {
        String msg = this.name + ": " + s;
        this.logger.warn(msg, throwable);
        if (this.logUtil != null) {
            this.logUtil.log(msg, throwable);
        }
    }

    protected void log_info(String s) {
        String msg = this.name + ": " + s;
        this.logger.info(msg);
        if (this.logUtil != null) {
            this.logUtil.log(msg);
        }
    }

    protected void log_info(String s, Throwable throwable) {
        String msg = this.name + ": " + s;
        this.logger.info(msg, throwable);
        if (this.logUtil != null) {
            this.logUtil.log(msg, throwable);
        }
    }

    protected void log_debug(String s) {
        String msg = this.name + ": " + s;
        this.logger.debug(msg);
        if (this.logUtil != null) {
            this.logUtil.debug(msg);
        }
    }

    protected void log_debug(String s, Throwable throwable) {
        String msg = this.name + ": " + s;
        this.logger.debug(msg, throwable);
        if (this.logUtil != null) {
            this.logUtil.debug(msg, throwable);
        }
    }

    protected void log_trace(String s) {
        this.logger.trace(this.name + ": " + s);
    }

    protected void log_trace(String s, Throwable throwable) {
        this.logger.trace(this.name + ": " + s, throwable);
    }

    public final void addConnectionPoolManagerListener(ConnectionPoolManagerListener listener) {
        this.listeners.add(listener);
    }

    public final void removeConnectionPoolManagerListener(ConnectionPoolManagerListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInstancesChangedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolManagerEvent event = new ConnectionPoolManagerEvent(this);
        ArrayList<ConnectionPoolManagerListener> x = null;
        List<ConnectionPoolManagerListener> list = this.listeners;
        synchronized (list) {
            x = new ArrayList<ConnectionPoolManagerListener>(this.listeners);
        }
        for (ConnectionPoolManagerListener cpml : x) {
            cpml.poolManagerInstancesChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReleasedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolManagerEvent event = new ConnectionPoolManagerEvent(this);
        ArrayList<ConnectionPoolManagerListener> x = null;
        List<ConnectionPoolManagerListener> list = this.listeners;
        synchronized (list) {
            x = new ArrayList<ConnectionPoolManagerListener>(this.listeners);
        }
        for (ConnectionPoolManagerListener cpml : x) {
            cpml.poolManagerReleased(event);
        }
        this.listeners.clear();
    }

    private static final class Releaser
    extends Thread {
        private ConnectionPoolManager instance;

        private Releaser() {
            this.setDaemon(true);
        }

        private Releaser(ConnectionPoolManager cpm) {
            this.instance = cpm;
        }

        @Override
        public void run() {
            if (this.instance == null) {
                for (ConnectionPoolManager cpm : ConnectionPoolManager.getInstances()) {
                    if (cpm.isReleased()) continue;
                    cpm.release();
                }
            } else if (!this.instance.isReleased()) {
                this.instance.release();
            }
        }
    }
}

