/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.util.EventObject;
import snaq.util.ObjectPool;
import snaq.util.Reusable;

public class ObjectPoolEvent<T extends Reusable>
extends EventObject {
    public static final int INIT_COMPLETED = 1;
    public static final int CHECKOUT = 2;
    public static final int CHECKIN = 3;
    public static final int VALIDATION_ERROR = 4;
    public static final int MAX_POOL_LIMIT_REACHED = 5;
    public static final int MAX_POOL_LIMIT_EXCEEDED = 6;
    public static final int MAX_SIZE_LIMIT_REACHED = 7;
    public static final int MAX_SIZE_LIMIT_ERROR = 8;
    public static final int PARAMETERS_CHANGED = 9;
    public static final int POOL_FLUSHED = 10;
    public static final int POOL_RELEASED = 11;
    private final int type;
    private int minPool;
    private int maxPool;
    private int maxSize;
    private long idleTimeout;
    private int checkedOut;
    private int freeCount;
    private int size;
    private float hitRate;

    public ObjectPoolEvent(ObjectPool<T> pool, int type) {
        super(pool);
        this.type = type;
    }

    public ObjectPool<T> getPool() {
        return (ObjectPool)this.getSource();
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        switch (this.type) {
            case 1: {
                return "INIT_COMPLETED";
            }
            case 2: {
                return "CHECKOUT";
            }
            case 3: {
                return "CHECKIN";
            }
            case 4: {
                return "VALIDATION_ERROR";
            }
            case 5: {
                return "MAX_POOL_LIMIT_REACHED";
            }
            case 6: {
                return "MAX_POOL_LIMIT_EXCEEDED";
            }
            case 7: {
                return "MAX_SIZE_LIMIT_REACHED";
            }
            case 8: {
                return "MAX_SIZE_LIMIT_ERROR";
            }
            case 9: {
                return "PARAMETERS_CHANGED";
            }
            case 10: {
                return "POOL_FLUSHED";
            }
            case 11: {
                return "POOL_RELEASED";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[source=");
        sb.append(this.source.toString());
        sb.append(",type=");
        sb.append(this.getTypeString());
        sb.append(']');
        return sb.toString();
    }

    public boolean isPoolInitCompleted() {
        return this.type == 1;
    }

    public boolean isPoolCheckOut() {
        return this.type == 2;
    }

    public boolean isPoolCheckIn() {
        return this.type == 3;
    }

    public boolean isValidationError() {
        return this.type == 4;
    }

    public boolean isMaxPoolLimitReached() {
        return this.type == 5;
    }

    public boolean isMaxPoolLimitExceeded() {
        return this.type == 6;
    }

    public boolean isMaxSizeLimitReached() {
        return this.type == 7;
    }

    public boolean isMaxSizeLimitError() {
        return this.type == 8;
    }

    public boolean isPoolParametersChanged() {
        return this.type == 9;
    }

    public boolean isPoolFlushed() {
        return this.type == 10;
    }

    public boolean isPoolReleased() {
        return this.type == 11;
    }

    void setMinPool(int i) {
        this.minPool = i;
    }

    void setMaxPool(int i) {
        this.maxPool = i;
    }

    void setMaxSize(int i) {
        this.maxSize = i;
    }

    void setIdleTimeout(long i) {
        this.idleTimeout = i;
    }

    void setCheckOut(int i) {
        this.checkedOut = i;
    }

    void setFreeCount(int i) {
        this.freeCount = i;
    }

    void setSize(int i) {
        this.size = i;
    }

    void setPoolHitRate(float f) {
        this.hitRate = f;
    }

    public int getMinPool() {
        return this.minPool;
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getCheckedOut() {
        return this.checkedOut;
    }

    public int getFreeCount() {
        return this.freeCount;
    }

    public int getSize() {
        return this.size;
    }

    public float getPoolHitRate() {
        return this.hitRate;
    }
}

