/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import snaq.db.ConnectionPool;
import snaq.db.ConnectionPoolEvent;
import snaq.db.ConnectionPoolListener;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.db.SimpleQueryValidator;
import snaq.util.ObjectPool;

public class DBPoolDataSource
implements DataSource,
ConnectionPoolListener {
    protected static final String POOL_NAME_PREFIX = "DBPoolDataSource-";
    protected static final Logger logger = LoggerFactory.getLogger(DBPoolDataSource.class);
    protected transient Driver driver;
    protected transient ConnectionPool pool;
    protected transient PrintWriter logWriter;
    private String description;
    private String name;
    private String driverClassName;
    private String url;
    private String passwordDecoderClassName;
    private String validatorClassName;
    private String validationQuery;
    private String selection;
    private int minPool = 0;
    private int maxPool = 0;
    private int maxSize = 0;
    private int idleTimeout = 0;
    private int loginTimeout = 3;
    private Properties props = new Properties();
    private boolean shutdownHook = false;

    public synchronized void registerShutdownHook() {
        this.shutdownHook = true;
        if (this.pool != null) {
            this.pool.registerShutdownHook();
        }
    }

    public synchronized void removeShutdownHook() {
        this.shutdownHook = false;
        if (this.pool != null) {
            this.pool.removeShutdownHook();
        }
    }

    protected synchronized void log(String message) {
        String s = this.name != null ? this.name + ": " + message : message;
        logger.info(s);
        if (this.logWriter != null) {
            this.logWriter.println(s);
        }
    }

    protected synchronized void log(String message, Throwable throwable) {
        String s = this.name != null ? this.name + ": " + message : message;
        logger.info(s, throwable);
        if (this.logWriter != null) {
            this.logWriter.println(s);
            throwable.printStackTrace(this.logWriter);
        }
    }

    protected synchronized void createConnectionPool() throws SQLException {
        ConnectionValidator cv;
        logger.debug("ClassLoader is of type: " + this.getClass().getClassLoader().getClass().getName());
        if (this.driver == null) {
            try {
                this.driver = (Driver)Class.forName(this.getDriverClassName()).newInstance();
                DriverManager.registerDriver(this.driver);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException ex) {
                SQLException sqlx = new SQLException("Unable to register JDBC driver: " + this.getDriverClassName());
                sqlx.initCause(ex);
                this.log(sqlx.getMessage(), sqlx);
                throw sqlx;
            }
        }
        String poolName = POOL_NAME_PREFIX + this.name;
        this.pool = new ConnectionPool(poolName, this.getMinPool(), this.getMaxPool(), this.getMaxSize(), this.getIdleTimeout(), this.getUrl(), this.props);
        this.pool.addConnectionPoolListener(this);
        if (this.getLogWriter() != null) {
            this.pool.setLog(this.getLogWriter());
        }
        if (this.shutdownHook) {
            this.pool.registerShutdownHook();
        }
        if (this.validatorClassName != null && !"".equals(this.validatorClassName)) {
            try {
                cv = (ConnectionValidator)Class.forName(this.validatorClassName).newInstance();
                this.pool.setValidator(cv);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                this.log("Unable to instantiate validator class: " + this.validatorClassName);
            }
        } else if (this.validationQuery != null && !"".equals(this.validationQuery)) {
            cv = new SimpleQueryValidator(this.validationQuery);
            this.pool.setValidator(cv);
        }
        if (this.passwordDecoderClassName != null && !"".equals(this.passwordDecoderClassName)) {
            try {
                PasswordDecoder pd = (PasswordDecoder)Class.forName(this.passwordDecoderClassName).newInstance();
                this.pool.setPasswordDecoder(pd);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                this.log("Unable to instantiate password decoder class: " + this.passwordDecoderClassName);
            }
        }
        if (this.selection != null) {
            switch (this.selection) {
                case "FIFO": {
                    this.pool.setSelectionStrategy(ObjectPool.Strategy.SELECT_FIFO);
                    break;
                }
                case "RANDOM": {
                    this.pool.setSelectionStrategy(ObjectPool.Strategy.SELECT_RANDOM);
                    break;
                }
            }
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.pool == null) {
            this.createConnectionPool();
        }
        return this.getLoginTimeout() > 0 ? this.pool.getConnection(1000L * (long)this.getLoginTimeout()) : this.pool.getConnection();
    }

    @Override
    public synchronized Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Unsupport method; use getConnection() instead.");
    }

    public synchronized void releaseConnectionPool() {
        if (this.pool != null) {
            this.pool.releaseForcibly();
        }
        this.pool = null;
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
    }

    public synchronized String getUser() {
        return this.props.getProperty("user");
    }

    public synchronized void setUser(String username) {
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        this.props.setProperty("user", username);
    }

    public synchronized String getPassword() {
        return this.props.getProperty("password");
    }

    public synchronized void setPassword(String password) {
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        this.props.setProperty("password", password);
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String driverClassName) {
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        this.driverClassName = driverClassName;
    }

    public synchronized String getPasswordDecoderClassName() {
        return this.passwordDecoderClassName;
    }

    public synchronized void setPasswordDecoderClassName(String decoderClassName) {
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        this.passwordDecoderClassName = decoderClassName;
    }

    public synchronized String getValidatorClassName() {
        return this.validatorClassName;
    }

    public synchronized void setValidatorClassName(String validatorClassName) {
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        this.validatorClassName = validatorClassName;
    }

    public synchronized String getValidationQuery() {
        return this.validationQuery;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        this.validationQuery = validationQuery;
    }

    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String url) {
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        this.url = url;
    }

    public synchronized int getMinPool() {
        return this.minPool;
    }

    public synchronized void setMinPool(int minPool) {
        this.maxPool = minPool;
        if (this.pool != null) {
            this.pool.setParameters(this.minPool, this.pool.getMaxPool(), this.pool.getMaxSize(), this.pool.getIdleTimeout());
        }
    }

    public synchronized int getMaxPool() {
        return this.maxPool;
    }

    public synchronized void setMaxPool(int maxPool) {
        this.maxPool = maxPool;
        if (this.pool != null) {
            this.pool.setParameters(this.pool.getMinPool(), this.maxPool, this.pool.getMaxSize(), this.pool.getIdleTimeout());
        }
    }

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        if (this.pool != null) {
            this.pool.setParameters(this.pool.getMinPool(), this.pool.getMaxPool(), this.maxSize, this.pool.getIdleTimeout());
        }
    }

    public synchronized int getIdleTimeout() {
        return this.idleTimeout;
    }

    public synchronized void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        if (this.pool != null) {
            this.pool.setParameters(this.pool.getMinPool(), this.pool.getMaxPool(), this.pool.getMaxSize(), (long)this.idleTimeout * 1000L);
        }
    }

    public synchronized String getConnectionProperty(String key) {
        Objects.requireNonNull(key);
        return this.props.getProperty(key);
    }

    public synchronized void setConnectionProperty(String key, String value) {
        Objects.requireNonNull(key);
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        if (value == null) {
            this.props.remove(key);
        }
        this.props.put(key, value);
    }

    public synchronized String getSelectionStrategy() {
        return this.selection;
    }

    public synchronized void setSelectionStrategy(String selection) {
        String s;
        if (this.pool != null) {
            throw new IllegalStateException("Cannot call this method after DBPoolDataSource has been initialized");
        }
        if (selection == null) {
            this.selection = null;
            return;
        }
        switch (s = selection.trim().toUpperCase()) {
            case "LIFO": 
            case "FIFO": 
            case "RANDOM": {
                this.selection = selection;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid selection strategy specified: " + selection);
            }
        }
    }

    @Override
    public synchronized PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter out) {
        this.logWriter = out;
        if (this.pool != null) {
            this.pool.setLog(this.logWriter);
        }
    }

    @Override
    public synchronized void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public synchronized int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void release() {
        this.pool.release();
    }

    public void releaseAsync() {
        this.pool.releaseAsync();
    }

    public void releaseForcibly() {
        this.pool.releaseForcibly();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append('[');
        sb.append("name=");
        sb.append(this.getName());
        sb.append(",driverClassName=");
        sb.append(this.getDriverClassName());
        sb.append(",url=");
        sb.append(this.getUrl());
        sb.append(",user=");
        sb.append(this.getUser());
        sb.append(",loginTimeout=");
        sb.append(this.getLoginTimeout());
        sb.append(",minPool=");
        sb.append(this.getMinPool());
        sb.append(",maxPool=");
        sb.append(this.getMaxPool());
        sb.append(",maxSize=");
        sb.append(this.getMaxSize());
        sb.append(",idleTimeout=");
        sb.append(this.getIdleTimeout());
        sb.append("s");
        return sb.toString();
    }

    @Override
    public synchronized boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.pool);
    }

    @Override
    public synchronized <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this.pool);
        }
        catch (ClassCastException ccx) {
            throw new SQLException("Invalid interface specified for unwrap operation: " + iface.getName(), ccx);
        }
    }

    @Override
    public void poolInitCompleted(ConnectionPoolEvent evt) {
    }

    @Override
    public void poolCheckOut(ConnectionPoolEvent evt) {
    }

    @Override
    public void poolCheckIn(ConnectionPoolEvent evt) {
    }

    @Override
    public void validationError(ConnectionPoolEvent evt) {
    }

    @Override
    public void maxPoolLimitReached(ConnectionPoolEvent evt) {
    }

    @Override
    public void maxPoolLimitExceeded(ConnectionPoolEvent evt) {
    }

    @Override
    public void maxSizeLimitReached(ConnectionPoolEvent evt) {
    }

    @Override
    public void maxSizeLimitError(ConnectionPoolEvent evt) {
    }

    @Override
    public void poolFlushed(ConnectionPoolEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void poolParametersChanged(ConnectionPoolEvent evt) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            this.minPool = this.pool.getMinPool();
            this.maxPool = this.pool.getMaxPool();
            this.maxSize = this.pool.getMaxSize();
            this.idleTimeout = (int)this.pool.getIdleTimeout();
        }
    }

    @Override
    public synchronized void poolReleased(ConnectionPoolEvent evt) {
        this.pool.removeConnectionPoolListener(this);
        this.pool = null;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("DBPool uses SLF4J logging.");
    }
}

