/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import snaq.db.StatementListener;

public class CachedStatement
implements Statement {
    protected static final String MSG_STATEMENT_CLOSED = "Statement is closed";
    private StatementListener listener;
    protected Statement st;
    private boolean open = true;
    protected boolean checking = false;
    protected boolean cacheable = false;

    public CachedStatement(Statement st) {
        this.st = st;
    }

    void setChecking(boolean b) {
        this.checking = b;
    }

    void setCacheable(boolean b) {
        this.cacheable = b;
    }

    boolean isCacheable() {
        return this.cacheable;
    }

    protected String getParametersString() {
        StringBuilder sb = new StringBuilder();
        try {
            switch (this.getResultSetType()) {
                case 1004: {
                    sb.append("TYPE_SCROLL_INSENSITIVE");
                    break;
                }
                case 1005: {
                    sb.append("TYPE_SCROLL_SENSITIVE");
                    break;
                }
                default: {
                    sb.append("TYPE_FORWARD_ONLY");
                    break;
                }
            }
        }
        catch (SQLException sqlx) {
            sb.append("TYPE_UNKNOWN");
        }
        sb.append(',');
        try {
            switch (this.getResultSetConcurrency()) {
                case 1008: {
                    sb.append("CONCUR_UPDATABLE");
                    break;
                }
                default: {
                    sb.append("CONCUR_READ_ONLY");
                    break;
                }
            }
        }
        catch (SQLException sqlx) {
            sb.append("CONCUR_UNKNOWN");
        }
        sb.append(',');
        try {
            switch (this.getResultSetHoldability()) {
                case 2: {
                    sb.append("CLOSE_CURSORS_AT_COMMIT");
                    break;
                }
                case 1: {
                    sb.append("HOLD_CURSORS_OVER_COMMIT");
                }
            }
        }
        catch (SQLException sqlx) {
            sb.append("HOLD_UNKNOWN");
        }
        return sb.toString();
    }

    public void recycle() throws SQLException {
        ResultSet rs = this.st.getResultSet();
        if (rs != null) {
            rs.close();
        }
        try {
            this.st.clearWarnings();
        }
        catch (SQLException sqlx) {
            // empty catch block
        }
        try {
            this.st.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.listener != null) {
            this.listener.statementClosed(this);
        } else {
            this.release();
        }
    }

    public void release() throws SQLException {
        this.st.close();
        this.st = null;
        this.setStatementListener(null);
    }

    void setOpen() {
        this.open = true;
    }

    void setStatementListener(StatementListener x) {
        this.listener = x;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.executeUpdate(sql);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (!this.open && !this.checking) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (!this.open && !this.checking) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        this.st.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (!this.open && !this.checking) {
            throw new SQLException(MSG_STATEMENT_CLOSED);
        }
        return this.st.getResultSetHoldability();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.st);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            T x = iface.cast(this.st);
            this.cacheable = false;
            return x;
        }
        catch (ClassCastException ccx) {
            throw new SQLException("Invalid type specified for unwrap operation: " + iface.getName(), ccx);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (poolable && !this.cacheable) {
            throw new SQLException("Cannot enable pooling on this statement");
        }
        this.setCacheable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.isCacheable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.st.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.st.isCloseOnCompletion();
    }
}

