/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import snaq.db.CacheConnection;
import snaq.db.ConnectionPoolEvent;
import snaq.db.ConnectionPoolListener;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.db.jmx.JmxUtils;
import snaq.util.EventDispatcher;
import snaq.util.EventNotifier;
import snaq.util.ObjectPool;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolListener;

public class ConnectionPool
extends ObjectPool<CacheConnection> {
    private String url;
    private String user;
    private String pass;
    private Properties props;
    private ConnectionValidator validator = new DefaultValidator();
    private PasswordDecoder decoder;
    private boolean cacheSS;
    private boolean cachePS;
    private boolean cacheCS;
    private final List<ConnectionPoolListener> listeners = new CopyOnWriteArrayList<ConnectionPoolListener>();
    private EventDispatcher<ConnectionPoolListener, ConnectionPoolEvent> eventDispatcher;
    private boolean recycleAfterDelegateUse = false;
    private boolean mbeanRegistered = false;
    private String mbeanRegisteredName;

    public ConnectionPool(String name, int minPool, int maxPool, int maxSize, long idleTimeout, String url, String username, String password) {
        super(name, minPool, maxPool, maxSize, idleTimeout);
        this.url = url;
        this.user = username;
        this.pass = password;
        this.props = null;
        this.setCaching(true);
        this.addObjectPoolListener(new EventRelay());
        this.eventDispatcher = new EventDispatcher<ConnectionPoolListener, ConnectionPoolEvent>(this.listeners, new Notifier());
        this.eventDispatcher.start();
    }

    public ConnectionPool(String name, int maxPool, int maxSize, long idleTimeout, String url, String username, String password) {
        this(name, 0, maxPool, maxSize, idleTimeout, url, username, password);
    }

    public ConnectionPool(String name, int minPool, int maxPool, int maxSize, long idleTimeout, String url, Properties props) {
        this(name, minPool, maxPool, maxSize, idleTimeout, url, null, null);
        this.props = props;
        if (props != null) {
            this.pass = props.getProperty("password");
        }
    }

    public ConnectionPool(String name, int maxPool, int maxSize, long idleTimeout, String url, Properties props) {
        this(name, 0, maxPool, maxSize, idleTimeout, url, props);
    }

    public void registerMBean() {
        if (this.mbeanRegistered) {
            return;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            this.mbeanRegisteredName = "snaq.db:type=ConnectionPool,name=\"" + this.getName() + "\"";
            ObjectName name = new ObjectName(this.mbeanRegisteredName);
            mbs.registerMBean(JmxUtils.createObjectPoolMBean(this), name);
            this.mbeanRegistered = true;
            this.log_info("Registered MBean for JMX access");
        }
        catch (Exception ex) {
            this.log_warn("Unable to register pool with MBean server", ex);
        }
    }

    public void unregisterMBean() {
        if (!this.mbeanRegistered) {
            this.log_warn("Unable to unregister pool from MBean server: not registered");
            return;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(this.mbeanRegisteredName);
            mbs.unregisterMBean(name);
            this.mbeanRegistered = false;
        }
        catch (Exception ex) {
            this.log_warn("Unable to unregister pool from MBean server", ex);
        }
    }

    @Override
    protected CacheConnection create() throws SQLException {
        Connection con = null;
        CacheConnection ccon = null;
        try {
            if (this.props != null) {
                if (this.decoder != null) {
                    this.props.setProperty("password", new String(this.decoder.decode(this.pass)));
                }
                this.log_info("Getting connection (properties): " + this.url);
                con = DriverManager.getConnection(this.url, this.props);
                if (this.decoder != null) {
                    this.props.setProperty("password", this.pass);
                }
            } else if (this.user != null) {
                if (this.decoder != null) {
                    this.log_info("Getting connection (user/enc.password): " + this.url);
                    con = DriverManager.getConnection(this.url, this.user, new String(this.decoder.decode(this.pass)));
                } else {
                    this.log_info("Getting connection (user/password): " + this.url);
                    con = DriverManager.getConnection(this.url, this.user, this.pass);
                }
            } else {
                this.log_info("Getting connection (just URL): " + this.url);
                con = DriverManager.getConnection(this.url);
            }
            ccon = new CacheConnection(this, con);
            ccon.setCacheStatements(this.cacheSS);
            ccon.setCachePreparedStatements(this.cachePS);
            ccon.setCacheCallableStatements(this.cacheCS);
            this.log_info("Created a new connection");
            for (SQLWarning warn = con.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                this.log_info("Warning - " + warn.getMessage());
            }
        }
        catch (SQLException sqlx) {
            this.log_info("Can't create a new connection for " + this.url, sqlx);
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sqlx2) {
                this.log_warn("Unable to close connection", sqlx2);
            }
            throw sqlx;
        }
        return ccon;
    }

    @Override
    protected boolean isValid(CacheConnection cc) {
        if (cc == null) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        try {
            boolean valid = this.validator.isValid(cc.getRawConnection());
            if (!valid) {
                this.firePoolEvent(4);
            }
            return valid;
        }
        catch (SQLException sqlx) {
            this.log_debug("SQLException during validation", sqlx);
            return false;
        }
    }

    @Deprecated
    public final synchronized int getPoolSize() {
        return this.getMaxPool();
    }

    public void setValidator(ConnectionValidator cv) {
        this.validator = cv;
    }

    public ConnectionValidator getValidator() {
        return this.validator;
    }

    public void setPasswordDecoder(PasswordDecoder pd) {
        this.decoder = pd;
    }

    public PasswordDecoder getPasswordDecoder() {
        return this.decoder;
    }

    @Override
    protected void destroy(CacheConnection cc) {
        if (cc == null) {
            return;
        }
        try {
            cc.release();
            this.log_info("Destroyed connection");
        }
        catch (SQLException sqlx) {
            this.log_warn("Can't destroy connection", sqlx);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            CacheConnection cc = (CacheConnection)super.checkOut();
            if (cc != null) {
                cc.setOpen();
                return cc;
            }
            return null;
        }
        catch (Exception ex) {
            this.log_warn("Error getting connection", ex);
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
                this.log_warn("Error getting connection", ex);
            }
            throw new SQLException(ex.getMessage());
        }
    }

    public Connection getConnection(long timeout) throws SQLException {
        try {
            CacheConnection cc = (CacheConnection)super.checkOut(timeout);
            if (cc != null) {
                cc.setOpen();
                return cc;
            }
            return null;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            this.log_warn("Error getting connection", ex);
            throw new SQLException(ex.getMessage());
        }
    }

    protected void freeConnection(Connection c) throws SQLException {
        if (c == null || !CacheConnection.class.isInstance(c)) {
            this.log_warn("Attempt to return invalid item");
        } else {
            super.checkIn((CacheConnection)c);
        }
    }

    @Override
    protected void postRelease() {
        this.listeners.clear();
        if (this.eventDispatcher != null) {
            this.eventDispatcher.halt();
            try {
                this.eventDispatcher.join();
            }
            catch (InterruptedException ix) {
                this.log_warn("Interrupted during halting of event dispatch thread", ix);
            }
            this.eventDispatcher = null;
        }
    }

    @Override
    protected float getIdleTimeoutMultiplier() {
        return 1000.0f;
    }

    public void setCaching(boolean b) {
        this.cachePS = this.cacheCS = b;
        this.cacheSS = this.cacheCS;
    }

    public void setCaching(boolean ss, boolean ps, boolean cs) {
        this.cacheSS = ss;
        this.cachePS = ps;
        this.cacheCS = cs;
    }

    public boolean isCachingStatements() {
        return this.cacheSS;
    }

    public boolean isCachingPreparedStatements() {
        return this.cachePS;
    }

    public boolean isCachingCallableStatements() {
        return this.cacheCS;
    }

    protected final void setPoolAccessFIFO() {
        super.setAccessFIFO();
    }

    protected final void setPoolAccessLIFO() {
        super.setAccessLIFO();
    }

    protected final void setPoolAccessRandom() {
        super.setAccessRandom();
    }

    public final void setRecycleAfterDelegateUse(boolean b) {
        this.recycleAfterDelegateUse = b;
    }

    public boolean isRecycleAfterDelegateUse() {
        return this.recycleAfterDelegateUse;
    }

    @Override
    protected long getMinimumCleaningInterval() {
        return 1000L;
    }

    @Override
    protected long getMaximumCleaningInterval() {
        return 5000L;
    }

    public final void addConnectionPoolListener(ConnectionPoolListener listener) {
        this.listeners.add(listener);
    }

    public final void removeConnectionPoolListener(ConnectionPoolListener listener) {
        this.listeners.remove(listener);
    }

    private final void firePoolEvent(int type) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, type);
        this.eventDispatcher.dispatchEvent(poolEvent);
    }

    private final void firePoolReleasedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 11);
        for (ConnectionPoolListener listener : this.listeners) {
            try {
                listener.poolReleased(poolEvent);
            }
            catch (RuntimeException rx) {
                this.log_warn("Exception thrown by listener on pool release", rx);
            }
        }
    }

    private final class Notifier
    implements EventNotifier<ConnectionPoolListener, ConnectionPoolEvent> {
        private Notifier() {
        }

        @Override
        public void notifyListener(ConnectionPoolListener cpl, ConnectionPoolEvent evt) {
            try {
                switch (evt.getType()) {
                    case 1: {
                        cpl.poolInitCompleted(evt);
                        break;
                    }
                    case 2: {
                        cpl.poolCheckOut(evt);
                        break;
                    }
                    case 3: {
                        cpl.poolCheckIn(evt);
                        break;
                    }
                    case 4: {
                        cpl.validationError(evt);
                        break;
                    }
                    case 5: {
                        cpl.maxPoolLimitReached(evt);
                        break;
                    }
                    case 6: {
                        cpl.maxPoolLimitExceeded(evt);
                        break;
                    }
                    case 7: {
                        cpl.maxSizeLimitReached(evt);
                        break;
                    }
                    case 8: {
                        cpl.maxSizeLimitError(evt);
                        break;
                    }
                    case 9: {
                        cpl.poolParametersChanged(evt);
                        break;
                    }
                    case 10: {
                        cpl.poolFlushed(evt);
                        break;
                    }
                    case 11: {
                        cpl.poolReleased(evt);
                        break;
                    }
                }
            }
            catch (RuntimeException rx) {
                ConnectionPool.this.log_warn("Exception raised by pool listener", rx);
            }
        }
    }

    private final class EventRelay
    implements ObjectPoolListener {
        private EventRelay() {
        }

        @Override
        public void poolInitCompleted(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(1);
        }

        @Override
        public void poolCheckOut(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(2);
        }

        @Override
        public void poolCheckIn(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(3);
        }

        @Override
        public void validationError(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(4);
        }

        @Override
        public void maxPoolLimitReached(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(5);
        }

        @Override
        public void maxPoolLimitExceeded(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(6);
        }

        @Override
        public void maxSizeLimitReached(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(7);
        }

        @Override
        public void maxSizeLimitError(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(8);
        }

        @Override
        public void poolParametersChanged(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(9);
        }

        @Override
        public void poolFlushed(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolEvent(10);
        }

        @Override
        public void poolReleased(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolReleasedEvent();
            ConnectionPool.this.listeners.clear();
        }
    }

    private static final class DefaultValidator
    implements ConnectionValidator {
        private DefaultValidator() {
        }

        @Override
        public boolean isValid(Connection con) {
            try {
                return con instanceof CacheConnection ? true : !con.isClosed();
            }
            catch (SQLException sqlx) {
                return false;
            }
        }
    }
}

