package net.smartlab.web.auth.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 */
public class ImageGenerator {

	/**
	 * TODO documentation
	 */
	private Font font;

	/**
	 * TODO documentation
	 */
	private Color color;

	/**
	 * TODO documentation
	 */
	private float size;

	/**
	 * TODO documentation
	 */
	private ImageIcon background;

	private final static String CHARS = "ABCDEFGHIJKLMNOPQRSTUWXYZ1234567890";


	/**
	 * TODO documentation
	 * 
	 * @param font
	 */
	public void setFont(Font font) {
		this.font = font;
	}

	/**
	 * TODO documentation
	 * 
	 * @param font
	 * @throws FontFormatException
	 */
	public void setFont(String font) throws IOException, FontFormatException {
		this.font = Font.createFont(Font.TRUETYPE_FONT, new FileInputStream(font));
	}

	/**
	 * TODO documentation
	 * 
	 * @param Color
	 */
	public void setColor(Color Color) {
		this.color = Color;
	}

	/**
	 * TODO documentation
	 * 
	 * @param size
	 */
	public void setSize(float size) {
		this.size = size;
	}

	/**
	 * TODO documentation
	 * 
	 * @param background
	 */
	public void setBackground(ImageIcon background) {
		this.background = background;
	}

	/**
	 * TODO documentation
	 * 
	 * @param background
	 */
	public void setBackground(String background) {
		this.background = new ImageIcon(background);
	}

	public static void main(String[] args) throws Exception {
		ImageGenerator i = new ImageGenerator();
		OutputStream os = new FileOutputStream("C:/test.png");
		i.font = Font.createFont(Font.TRUETYPE_FONT, new FileInputStream("c:/windows/fonts/Arial.ttf"));
		i.color = new Color(255, 0, 0, 128);
		i.size = 20.0f;
		BufferedImage buffer = i.generate("some simple text");
		// output the image as png
		ImageIO.write(buffer, "png", os);
		os.close();
	}

	public BufferedImage generate(int length) throws Exception {
		// generate a string
		StringBuffer randomized = new StringBuffer(length);
		for (int i = 0; i < length; i++) {
			int index = (int)Math.floor(Math.random() * CHARS.length());
			randomized.append(CHARS.charAt(index - 1));
		}
		return this.generate(randomized.toString());
	}

	/**
	 * TODO documentation
	 * 
	 * @param text
	 * @return
	 * @throws Exception
	 */
	public BufferedImage generate(String text) throws Exception {
		int width = background.getIconWidth();
		int height = background.getIconHeight();
		BufferedImage buffer = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		Graphics2D canvas = buffer.createGraphics();
		canvas = buffer.createGraphics();
		canvas.setComposite(AlphaComposite.Src);
		canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		canvas.drawImage(background.getImage(), null, null);
		canvas.setComposite(AlphaComposite.SrcOver);
		font = font.deriveFont(size);
		canvas.setFont(font);
		canvas.setColor(color);
		FontRenderContext renderer = canvas.getFontRenderContext();
		Rectangle2D bounds = font.getStringBounds(text, renderer);
		GlyphVector glyphs = font.createGlyphVector(renderer, text);
		for (int i = 0; i < glyphs.getNumGlyphs(); i++) {
			double rotation = (Math.random() * 2) - 1;
			AffineTransform transform = AffineTransform.getRotateInstance(rotation);
			double scaling = (Math.random() - 0.5) * 0.5;
			transform.scale(scaling, scaling);
			glyphs.setGlyphTransform(i, transform);
		}
		canvas.drawGlyphVector(glyphs, (float)(((float)width / 2) - bounds.getX()), (float)(((float)height / 2) - bounds.getY()));
		return buffer;
	}
}
