/**
 * 
 */
package net.smartlab.web.auth.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;



import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * This CLass contain static util method about Cryptography
 * 
 * @author svetrini
 *
 */
public class CryptoUtils {
	
	private final static Log logger = LogFactory.getLog(CryptoUtils.class);

	/**
	 * 
	 */
	private CryptoUtils() {
		// TODO Auto-generated constructor stub
	}
	
	/**
	 * Generate MD5 digest from data input
	 * @param data  byte array source for digesting
	 * @return MD5 digest byte array
	 */
	public static byte[] toMD5(byte[] data) {
		MessageDigest algorithm = null;
		try {
			algorithm = MessageDigest.getInstance("MD5");
		} catch (NoSuchAlgorithmException e) {
			logger.fatal("Current JDK doesn't support MD5", e);			
		}
		algorithm.reset();
		algorithm.update(data);		
		
		return algorithm.digest();
 

	}
	
	/**
	 * Generate MD5 digest ( with Hex Encoding ) from data input
	 * @param data byte array source for digesting
	 * @return MD5 digest char array
	 */
	public static String toHexMD5(byte[] data) {
		return new String(Hex.encodeHex(toMD5(data)));		

	}
	
	/**
	 * Compare two digest for equality 
	 * @param dataa one of the digest to compare.
	 * @param datab the other digest to compare.
	 * @return true if the digests are equal, false otherwise.
	 */
	public static boolean isEqualMD5(byte[] dataa, byte[] datab){
		return MessageDigest.isEqual(dataa, datab);
	}
	
	/**
	 * Compare two digest for equality 
	 * @param dataa one of the digest to compare.
	 * @param datab the other digest to compare.
	 * @return true if the digests are equal, false otherwise.
	 */
	public static boolean isEqualMD5(char[] dataa, char[] datab){
		String strDataa = new String(dataa);
		String strDatab = new String(datab);
		
		return isEqualMD5(strDataa.getBytes(), strDatab.getBytes());
	}
	
	/**
	 * Compare two digest for equality 
	 * @param dataa one of the digest to compare.
	 * @param datab the other digest to compare.
	 * @return true if the digests are equal, false otherwise.
	 */
	public static boolean isEqualMD5(String dataa, String datab){
		
		return isEqualMD5(dataa.getBytes(), datab.getBytes());
	}
	
	
	
	

}
