/**
 * 
 */
package net.smartlab.web.auth.handlers;

import java.util.Map;

import net.smartlab.web.auth.AuthorizationHandler;
import net.smartlab.web.auth.Scope;

/**
 * @author Stefano Vetrini
 *
 */
public class ScopeMethodAuthorizationHandler implements AuthorizationHandler {

	/**
	 * @uml.property  name="id"
	 */
	private String id;
	
	

	/* (non-Javadoc)
	 * @see net.smartlab.web.auth.AuthorizationHandler#onRequest(java.lang.Object[])
	 */
	public boolean onRequest(Object[] params) {
		Scope myScope = (Scope) params[0];
		Scope otherScope = (Scope) params[1];
		
		try {
			
				if (Class.forName(otherScope.getType().getType()).isInstance(Class.forName(myScope.getType().getType()).newInstance()) ) {
					return true;
				}
		} catch (Exception e) {
			//NOP
		}
		return false;
		
	}

	/* (non-Javadoc)
	 * @see net.smartlab.web.auth.Handler#destroy()
	 */
	public void destroy() throws Exception {
		//NOP

	}

	/* (non-Javadoc)
	 * @see net.smartlab.web.auth.Handler#getId()
	 */
	/**
	 * @return
	 * @uml.property  name="id"
	 */
	public String getId() {		
		return this.id;
	}

	/* (non-Javadoc)
	 * @see net.smartlab.web.auth.Handler#init(java.util.Map)
	 */
	public void init(Map parameters) throws Exception {				
		this.id = (String) parameters.get("id");				
	}

	/**
	 * @param id
	 * @uml.property  name="id"
	 */
	public void setId(String id) {
		this.id=id;
	}



}
