/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth.handlers;

import java.util.Map;

import net.smartlab.web.auth.AuthenticationException;
import net.smartlab.web.auth.AuthenticationHandler;
import net.smartlab.web.auth.Credentials;
import net.smartlab.web.auth.User;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 */
public class PasswordAuthenticationHandler implements AuthenticationHandler {
	private final static Log logger = LogFactory.getLog(PasswordAuthenticationHandler.class);

	/**
	 * @uml.property  name="id"
	 */
	private String id;

	public void onLogin(User user,Credentials credentials) throws AuthenticationException {
		if (logger.isDebugEnabled()) {
			logger.debug("onLogin() - start");
		}
		if (user != null && credentials!= null && credentials.getSecret().length>0  &&  user.getPassword().equals(new String(credentials.getSecret()))) {
			if (logger.isTraceEnabled()) {
				logger.trace("   password match");
			}
		} else {
			throw new AuthenticationException("Invalid credentials");
		}
		
	}

	public void onLogout(User user) throws AuthenticationException {
		if (user==null) throw new  AuthenticationException();
		if (user.getUsername()==null) throw new  AuthenticationException();
		
	}

	public void destroy() throws Exception {
		// TODO Auto-generated method stub
		
	}



	public void init(Map parameters) throws Exception {
		// TODO Auto-generated method stub
		
	}

	/**
	 * @return
	 * @uml.property  name="id"
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 * @uml.property  name="id"
	 */
	public void setId(String id) {
		this.id = id;
	}

	
}
