/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth.handlers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;

import net.smartlab.web.BusinessException;
import net.smartlab.web.DAOException;
import net.smartlab.web.auth.Domain;
import net.smartlab.web.auth.RegistrationHandler;
import net.smartlab.web.auth.User;
import net.smartlab.web.auth.UserFactory;
import net.smartlab.web.auth.User.Status;

import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.commons.el.VariableResolverImpl;
import org.apache.commons.el.parser.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.mock.MockPageContext;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 * @author svetrini
 */
public class EmailVerifierRegistrationHandler implements RegistrationHandler {

	private static final Log logger = LogFactory.getLog(EmailVerifierRegistrationHandler.class);

	private String host;

	private String from;

	private String port;

	private String systemName;

	private String username;

	private String password;

	private Map paramBeans = new HashMap();

	private Domain domain = Domain.getInstance();

	private static final String STATE_REQUEST_CONFIRM = "STATE_REQUEST_CONFIRM";

	private static final String STATE_RECIVE_CONFIRM = "STATE_RECIVE_CONFIRM";

	private static final String STATE_CONFIRMED = "STATE_CONFIRMED";

	public final String STATE_INSERT = "STATE_INSERT";

	private String id;

	private String reqObject;

	private String reqBody;

	private String resObject;

	private String resBody;


	public String onRegister(Map parameters, String step) {
		try {
			if (step.equals(STATE_INSERT)) {
				User user = new User();
				// Insert new user in db
				user.setStatus(Status.PENDING);
				UserFactory.getInstance().update(user);
				step = STATE_REQUEST_CONFIRM;
			} else if (step.equals(STATE_REQUEST_CONFIRM)) {
				User user = (User)UserFactory.getInstance().findByKey((String)parameters.get("id"));
				// FIXME
				if (user.getId() != 0) {
					try {
						user = domain.findUser(Long.toString(user.getId()));
						Map userProperties = user.getProperties();
						user.setProperty("trace", generateTrace());
						domain.updateUser(user);
						try {
							String message = generateRequestMessage(user);
							String object = generateRequestObject(user);
							String emailAddress = (String)userProperties.get("emailAddress");
							this.sendMail(emailAddress, object, message);
							step = STATE_RECIVE_CONFIRM;
						} catch (Exception e) {
							logger.error("Exception sending email", e);
						}
					} catch (BusinessException e) {
						logger.error("Exception generating Trace", e);
					}
				} else {
					throw new IllegalStateException();
				}
			} else if (step.equals(STATE_RECIVE_CONFIRM)) {
				User user = (User)UserFactory.getInstance().findByKey((String)parameters.get("id"));
				// FIXME
				if (user.getId() != 0) {
					Map userProperties = user.getProperties();
					try {
						user = domain.findUser("" + user.getId());
						// trace check
						if (userProperties.get("trace").equals(user.getProperty("trace"))) {
							// OK
							user.setStatus(Status.ENABLED);
							domain.updateUser(user);
							// send email response
							try {
								String message = generateResponseMessage(user);
								String object = generateResponseObject(user);
								String emailAddress = (String)userProperties.get("emailAddress");
								this.sendMail(emailAddress, object, message);
							} catch (Exception e) {
								logger.error("Exception sending email", e);
							}
							step = STATE_CONFIRMED;
						} else {
							// NO
						}
					} catch (BusinessException be) {
						logger.error(be);
					}
				} else {
					// FIXME
					throw new IllegalStateException();
				}
			}
		} catch (DAOException daoe) {
			logger.error("Exception storing user informations", daoe);
		}
		return step;
	}

	private String generateTrace() {
		Random random = new Random();
		String trace = Long.toHexString(random.nextLong());
		return trace;
	}

	private String generateResponseObject(User user) throws ELException, ParseException {
		HashMap beans = new HashMap();
		beans.putAll(this.paramBeans);
		beans.put("user", user);
		return parseParametricText(this.resObject, beans);
	}

	private String generateRequestObject(User user) throws ELException, ParseException {
		HashMap beans = new HashMap();
		beans.putAll(this.paramBeans);
		beans.put("user", user);
		return parseParametricText(this.reqObject, beans);
	}

	private String generateRequestMessage(User user) throws ELException, ParseException {
		HashMap beans = new HashMap();
		beans.putAll(this.paramBeans);
		beans.put("user", user);
		return parseParametricText(this.reqBody, beans);
	}

	private String generateResponseMessage(User user) throws ELException, ParseException {
		HashMap beans = new HashMap();
		beans.putAll(this.paramBeans);
		beans.put("user", user);
		return parseParametricText(this.resBody, beans);
	}

	public void destroy() throws Exception {
		// TODO Auto-generated method stub
	}

	public void init(Map parameters) throws Exception {
		this.systemName = (String)parameters.get("systemName");
		this.host = (String)parameters.get("smtp.host");
		this.port = (String)parameters.get("smtp.port");
		this.username = (String)parameters.get("smtp.user");
		this.password = (String)parameters.get("smtp.pass");
		this.from = (String)parameters.get("from");
		this.reqObject = (String)parameters.get("requestObject");
		this.reqBody = (String)parameters.get("requestBody");
		this.resObject = (String)parameters.get("responseObject");
		this.resBody = (String)parameters.get("responseBody");
		this.paramBeans.putAll(parameters);
	}

	/**
	 * @see net.smartlab.web.auth.Handler#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * @see net.smartlab.web.auth.Handler#setId(java.lang.String)
	 */
	public void setId(String id) {
		this.id = id;
	}

	private void sendMail(String to, String subject, String body) throws MessagingException,
			UnsupportedEncodingException {
		// Get system properties
		Properties properties = System.getProperties();
		// Setup mail server
		properties.put("mail.smtp.auth", "false");
		properties.put("mail.smtp.host", host);
		properties.put("mail.smtp.port", port);
		properties.put("mail.transport.protocol", "smtp");
		properties.put("mail.smtp.starttls.enable", "false");
		// Setup authentication
		Authenticator authenticator = null;
		if (username != null) {
			authenticator = new Authenticator() {
				// FIXME
			};
		}
		// Get session
		Session session = Session.getDefaultInstance(properties, authenticator);
		// session.setDebug(false);
		// Define message
		MimeMessage message = new MimeMessage(session);
		message.setContent(body, "text/html");
		logger.trace("message content: " + body);
		message.setFrom(new InternetAddress(from, systemName));
		message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
		message.setSubject(subject);
		// Send message
		Transport.send(message);
	}

	private static String parseParametricText(String text, HashMap beans) throws ELException, ParseException {
		String result = "";
		ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
		Class pExpectedType = String.class;
		PageContext pCtx = new tmpPageContext(beans);
		VariableResolver pResolver = new VariableResolverImpl(pCtx);
		FunctionMapper functions = null;
		result = (String)evaluator.evaluate(text, pExpectedType, pResolver, functions);
		logger.info(result);
		System.out.println(result);
		return result;
	}


	private static class tmpPageContext extends MockPageContext {

		public tmpPageContext(HashMap attributes) {
			super();
			super.attributes = attributes;
		}
	}


	public String onUpdate(User user, Map props, String step) throws Exception {
		// TODO implementation
		return null;
	}
}