/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth.handlers;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;

import net.smartlab.config.ConfigurationException;
import net.smartlab.web.auth.AuthenticationException;
import net.smartlab.web.auth.AuthenticationHandler;
import net.smartlab.web.auth.AuthorizationHandler;
import net.smartlab.web.auth.Credentials;
import net.smartlab.web.auth.User;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 */
public class DateTimeHandler implements AuthenticationHandler, AuthorizationHandler {

	private String id;

	private CronPattern pattern;


	/**
	 * @see net.smartlab.web.auth.Handler#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * @see net.smartlab.web.auth.Handler#setId(java.lang.String)
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @see net.smartlab.web.auth.Handler#init(java.util.Map)
	 */
	public void init(Map parameters) throws Exception {
		try {
			this.pattern = new CronPattern((String)parameters.get("pattern"));
		} catch (RuntimeException re) {
			throw new ConfigurationException("Pattern not found");
		}
	}

	/**
	 * @see net.smartlab.web.auth.AuthenticationHandler#onLogin(net.smartlab.web.auth.User,
	 *      net.smartlab.web.auth.Credentials)
	 */
	public void onLogin(User user, Credentials credential) throws Exception {
		if (!pattern.check()) {
			throw new AuthenticationException("Date/time check failed");
		}
	}

	/**
	 * @see net.smartlab.web.auth.AuthorizationHandler#check(java.lang.Object[])
	 */
	public boolean onRequest(Object[] params) {
		return pattern.check();
	}

	/**
	 * @see net.smartlab.web.auth.AuthenticationHandler#onLogout(net.smartlab.web.auth.User)
	 */
	public void onLogout(User user) throws Exception {
		return;
	}

	public void destroy() throws Exception {
		// TODO Auto-generated method stub
	}


	/**
	 * TODO documentation
	 * 
	 * @author rlogiacco
	 */
	public static class CronPattern {

		/**
		 * TODO documentation
		 */
		private boolean[] minutes = new boolean[60];

		/**
		 * TODO documentation
		 */
		private boolean[] hours = new boolean[24];

		/**
		 * TODO documentation
		 */
		private boolean[] daysOfWeek = new boolean[7];

		/**
		 * TODO documentation
		 */
		private boolean[] daysOfMonth = new boolean[31];

		/**
		 * TODO documentation
		 */
		private boolean[] months = new boolean[12];

		/**
		 * TODO documentation
		 */
		private String pattern;


		/**
		 * TODO documentation
		 * 
		 * @param pattern
		 */
		public CronPattern(String pattern) {
			this.pattern = pattern;
			StringTokenizer tokenizer = new StringTokenizer(pattern);
			for (int i = 0; tokenizer.hasMoreElements(); i++) {
				String token = tokenizer.nextToken();
				switch (i) {
					case 0: // Minutes
						this.parse(token, minutes, false);
						break;
					case 1: // Hours
						this.parse(token, hours, false);
						break;
					case 2: // Days of month
						this.parse(token, daysOfMonth, true);
						break;
					case 3: // Months
						this.parse(token, months, true);
						break;
					case 4: // Days of week
						this.parse(token, daysOfWeek, false);
						break;
				}
			}
		}

		/**
		 * TODO documentation
		 * 
		 * @param minutes
		 * @param hours
		 * @param daysOfMonth
		 * @param months
		 * @param daysOfWeek
		 */
		public CronPattern(String minutes, String hours, String daysOfMonth, String months, String daysOfWeek) {
			this.pattern = minutes + " " + hours + " " + daysOfMonth + " " + months + " " + daysOfWeek;
			this.parse(minutes, this.minutes, false);
			this.parse(hours, this.hours, false);
			this.parse(daysOfMonth, this.daysOfMonth, true);
			this.parse(months, this.months, true);
			this.parse(daysOfWeek, this.daysOfWeek, false);
		}

		/**
		 * Parses a cron-like string token in order to valorize the internal
		 * representation.
		 * 
		 * @param token the token to parse
		 * @param array the boolean array to valorize
		 * @param shift indicates if the first element has index 1 (true) or 0
		 *        (false)
		 * @throws Exception
		 */
		private void parse(String token, boolean[] array, boolean shift) {
			int step = 1;
			// Look for step first
			if (token.indexOf("/") > 0) {
				step = Integer.parseInt(token.substring(token.indexOf("/") + 1));
				token = token.substring(0, token.indexOf("/"));
				if (step == 0) {
					throw new NumberFormatException("Invalid step 0");
				}
			}
			// Check for any
			if (token.equals("*")) {
				for (int i = 0; i < array.length; i += step) {
					array[i] = true;
				}
				return;
			}
			// Check for list
			if (token.indexOf(",") > 0) {
				StringTokenizer tokenizer = new StringTokenizer(token, ",");
				while (tokenizer.hasMoreElements()) {
					parse(tokenizer.nextToken(), array, shift);
				}
				return;
			}
			// Check for interval
			if (token.indexOf("-") > 0) {
				int start = Integer.parseInt(token.substring(0, token.indexOf("-")));
				int end = Integer.parseInt(token.substring(token.indexOf("-") + 1));
				for (int j = (shift ? start - 1 : start); j <= (shift ? end - 1 : end); j += step) {
					array[j] = true;
				}
				return;
			}
			// Simple value
			int value = Integer.parseInt(token);
			array[(shift ? value - 1 : value)] = true;
			return;
		}

		/**
		 * TODO documentation
		 * 
		 * @return
		 */
		public boolean check() {
			return this.check(Calendar.getInstance());
		}

		/**
		 * TODO documentation
		 * 
		 * @param date
		 * @return
		 */
		public boolean check(Date date) {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(date);
			return this.check(calendar);
		}

		/**
		 * TODO documentation
		 * 
		 * @param calendar
		 * @return
		 */
		public boolean check(Calendar calendar) {
			return hours[calendar.get(Calendar.HOUR_OF_DAY)] && minutes[calendar.get(Calendar.MINUTE)]
					&& months[calendar.get(Calendar.MONTH)] && daysOfWeek[calendar.get(Calendar.DAY_OF_WEEK) - 1]
					&& daysOfMonth[calendar.get(Calendar.DAY_OF_MONTH) - 1];
		}

		/**
		 * @see java.lang.Object#toString()
		 */
		public String toString() {
			return pattern;
		}
	}
}
