/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth.handlers;

import java.util.Map;

import net.smartlab.config.ConfigurationException;
import net.smartlab.web.DAOException;
import net.smartlab.web.auth.AuthenticationException;
import net.smartlab.web.auth.AuthenticationHandler;
import net.smartlab.web.auth.AuthorizationHandler;
import net.smartlab.web.auth.Credentials;
import net.smartlab.web.auth.User;
import net.smartlab.web.auth.UserFactory;
import net.smartlab.web.auth.User.Status;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 */
public class ConcurrencyHandler implements AuthenticationHandler, AuthorizationHandler {

	private String id;
	private long max;

	/**
	 * @see net.smartlab.web.auth.Handler#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * @see net.smartlab.web.auth.Handler#setId(java.lang.String)
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @see net.smartlab.web.auth.Handler#init(java.util.Map)
	 */
	public void init(Map parameters) throws Exception {
		try {
			this.max = Long.parseLong((String)parameters.get("max"));
		} catch (NumberFormatException nfe) {
			throw new ConfigurationException("Error configuring handler", nfe);
		}
	}
	
	/**
	 * @see net.smartlab.web.auth.AuthenticationHandler#onLogin(net.smartlab.web.auth.User, net.smartlab.web.auth.Credentials)
	 */
	public void onLogin(User user, Credentials credential) throws Exception {
		if (!checkBound()) {
			throw new AuthenticationException("too many user");
		}
	}
	
	/**
	 * @see net.smartlab.web.auth.AuthorizationHandler#onRequest(java.lang.Object[])
	 */
	public boolean onRequest(Object[] params) {
		return checkBound();
	}

	/**
	 * @see net.smartlab.web.auth.AuthenticationHandler#onLogout(net.smartlab.web.auth.User)
	 */
	public void onLogout(User user) throws Exception {
		// TODO Auto-generated method stub
	}

	/**
	 * @see net.smartlab.web.auth.Handler#destroy()
	 */
	public void destroy() throws Exception {
		// TODO Auto-generated method stub
	}
	
	/**
	 * @return
	 * @throws DAOException
	 */
	private boolean checkBound() {
		try {
			return UserFactory.getInstance().count(Status.ONLINE) > max;
		} catch (DAOException daoe) {
			return false;
		}
	}
}
