/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth.handlers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

import net.smartlab.web.auth.AuthenticationHandler;
import net.smartlab.web.auth.Credentials;
import net.smartlab.web.auth.Domain;
import net.smartlab.web.auth.Handler;
import net.smartlab.web.auth.RegistrationHandler;
import net.smartlab.web.auth.User;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 */
public class ChainHandler implements Handler, AuthenticationHandler, RegistrationHandler {

	private String id;

	/**
	 * @uml.property name="handlers"
	 * @uml.associationEnd multiplicity="(0 -1)" ordering="true"
	 *                     inverse="chainHandler:net.smartlab.web.auth.Handler"
	 */
	private Map handlers = new HashMap();


	/**
	 * @see net.smartlab.web.auth.Handler#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * @see net.smartlab.web.auth.Handler#setId(java.lang.String)
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @see net.smartlab.web.auth.Handler#init(java.util.Map)
	 */
	public void init(Map parameters) throws Exception {
		StringTokenizer tokenizer = new StringTokenizer((String)parameters.get("nodes"));
		Collection authenticationHandlers = new ArrayList();
		handlers.put("AuthenticationHandler", authenticationHandlers);
		Collection registrationHandlers = new ArrayList();
		handlers.put("RegistrationHandler", registrationHandlers);
		while (tokenizer.hasMoreTokens()) {
			String node = tokenizer.nextToken().trim();
			if (Domain.getInstance().getHandler(node) instanceof AuthenticationHandler) {
				((Collection)handlers.get("AuthenticationHandler")).add(Domain.getInstance().getHandler(node));
			}
			if (Domain.getInstance().getHandler(node) instanceof RegistrationHandler) {
				((Collection)handlers.get("RegistrationHandler")).add(Domain.getInstance().getHandler(node));
			}
		}
	}

	/**
	 * @see net.smartlab.web.auth.AuthenticationHandler#onLogin(net.smartlab.web.auth.User,
	 *      net.smartlab.web.auth.Credentials)
	 */
	public void onLogin(User user, Credentials credential) throws Exception {
		for (Iterator iterator = ((AbstractList)handlers.get("AuthenticationHandler")).iterator(); iterator.hasNext();) {
			AuthenticationHandler handler = (AuthenticationHandler)iterator.next();
			handler.onLogin(user, credential);
		}
	}

	/**
	 * @see net.smartlab.web.auth.AuthenticationHandler#onLogout(net.smartlab.web.auth.User)
	 */
	public void onLogout(User user) throws Exception {
		for (Iterator iterator = ((AbstractList)handlers.get("AuthenticationHandler")).iterator(); iterator.hasNext();) {
			AuthenticationHandler handler = (AuthenticationHandler)iterator.next();
			handler.onLogout(user);
		}
	}

	/**
	 * @see net.smartlab.web.auth.RegistrationHandler#onRegister(net.smartlab.web.auth.User,
	 *      java.util.Map, java.lang.String)
	 */
	public String onRegister(Map parameters, String step) throws Exception {
		String result = step;
		for (Iterator iterator = ((AbstractList)handlers.get("RegistrationHandler")).iterator(); iterator.hasNext();) {
			RegistrationHandler handler = (RegistrationHandler)iterator.next();
			result = handler.onRegister(parameters, result);
			// FIXME result overrides previous one
			// TODO serialize the registrations
		}
		return result;
	}

	/**
	 * @see net.smartlab.web.auth.RegistrationHandler#onUpdate(net.smartlab.web.auth.User,
	 *      java.util.Map, java.lang.String)
	 */
	public String onUpdate(User user, Map parameters, String registrationState) throws Exception {
		String result = registrationState;
		for (Iterator iterator = ((AbstractList)handlers.get("RegistrationHandler")).iterator(); iterator.hasNext();) {
			RegistrationHandler handler = (RegistrationHandler)iterator.next();
			result = handler.onUpdate(user, parameters, result);
			// FIXME result overrides previous one
			// TODO serialize the registrations
		}
		return result;
	}

	/**
	 * @see net.smartlab.web.auth.Handler#destroy()
	 */
	public void destroy() throws Exception {
		for (Iterator iterator = handlers.values().iterator(); iterator.hasNext();) {
			Collection coll = (Collection)iterator.next();
			for (Iterator iterator2 = coll.iterator(); iterator2.hasNext();) {
				Handler handler = (Handler)iterator2.next();
				handler.destroy();
			}
		}
	}
}