/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth.aspects;

import java.lang.reflect.Method;

import net.smartlab.web.auth.AuthorizationException;
import net.smartlab.web.auth.Privilege;
import net.smartlab.web.auth.Scope;
import net.smartlab.web.auth.User;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * TODO documentation
 * 
 * @author svetrini
 * @author rlogiacco
 */
public class MethodAuthorizationInterceptor implements Interceptor {

	/**
	 * TODO documentation
	 */
	protected final Log logger = LogFactory.getLog(this.getClass());


	/**
	 * @see org.jboss.aop.advice.Interceptor#getName()
	 */
	public String getName() {
		return "net.smartlab.web.auth.method";
	}

	/**
	 * @see org.jboss.aop.advice.Interceptor#invoke(org.jboss.aop.joinpoint.Invocation)
	 */
	public Object invoke(Invocation invocation) throws Throwable {
		if (invocation instanceof MethodInvocation) {
			Method method = ((MethodInvocation)invocation).getMethod();
			
			boolean authorized = authorize(method);
			if (!authorized) {
				throw new AuthorizationException();
			} else {
				return invocation.invokeNext();
			}
		} else {
			logger.warn("unusual authorization check on " + invocation);
			return invocation.invokeNext();
		}
	}

	/**
	 * @param method
	 * @return
	 */
	protected boolean authorize(Method method) {
		boolean authorized = false;
		if (logger.isDebugEnabled()) {
			logger.debug("invoke(" + method.toString() + ") - entered");
		}
		char[] name = method.getName().toCharArray();
		Class[] scopes = method.getParameterTypes();
		String field =null;
		byte modifier = Privilege.EXECUTE;
		int index = 0;
		switch (name[0]) {
			case 's':
				if (name[1] == 'e' && name[2] == 't' && Character.isUpperCase(name[3])) {
					index = 3;
				}
				modifier = Privilege.WRITE;
				break;
			case 'g':
				if (name[1] == 'e' && name[2] == 't' && Character.isUpperCase(name[3])) {
					index = 3;
				}
				modifier = Privilege.READ;
				break;
			case 'i':
				if (name[1] == 's' && Character.isUpperCase(name[2])) {
					index = 2;
				}
				modifier = Privilege.READ;
				break;
		}
		
			name[index] = Character.toLowerCase(name[index]);
			field =new String(name).substring(index);
			//char[] buffer = new char[name.length - 3 + 1];
			//System.arraycopy(name, index, buffer, 0, buffer.length);
			//name = field.toCharArray();
		
		
		User currentUser = User.get();
		if (currentUser != null) {
			Privilege current = new Privilege(method.getDeclaringClass().getName(), field, modifier);
			if (logger.isDebugEnabled()) {
				logger.debug("comparing to privilege " + current);
			}
			if (scopes== null || scopes.length==0){
				authorized = currentUser.hasPrivilege(current);
			}else{
				authorized = true;
				for (int i = 0; i < scopes.length; i++) {
					Scope scope = null;
					String typeId = scopes[i].getName();
					if (typeId!=null){
						scope = new Scope();
						scope.setTypeId(typeId);
					}
					if (!currentUser.hasPrivilege(current, scope)){
						authorized = false;
						break;
					}
				}					
			}
		}
		return authorized;
	}
}