/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth.aspects;

import java.lang.reflect.Method;

import net.smartlab.web.auth.User;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * TODO documentation
 * 
 * @author svetrini
 * @author rlogiacco
 */
public class AuditInterceptor implements Interceptor {
	
	
	/**
	 * TODO documentation
	 * @uml.property  name="logger"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	protected final Log logger = LogFactory.getLog(this.getClass());


	/**
	 * @see org.jboss.aop.advice.Interceptor#getName()
	 */
	public String getName() {
		return "net.smartlab.web.auth.audit";
	}

	/**
	 * @see org.jboss.aop.advice.Interceptor#invoke(org.jboss.aop.joinpoint.Invocation)
	 */
	public Object invoke(Invocation invocation) throws Throwable {
		if (invocation instanceof MethodInvocation) {
			MethodInvocation mInvocation = (MethodInvocation)invocation;
			logger.info("[" + User.get().getDisplay() + "] " + mInvocation.getMethod() + " - start");
			if (logger.isDebugEnabled()){
				Class[] parameters = ((MethodInvocation)invocation).getMethod().getParameterTypes();
				Object[] arguments = ((MethodInvocation)invocation).getArguments();
				for (int i = 0; i < parameters.length; i++) {
			    logger.debug("   " + parameters[i].getName() + " = " + arguments[i]);
		    }
			}
			try {
				return invocation.invokeNext();
			} finally {
				logger.info(((MethodInvocation)invocation).getMethod() + " - end");
			}
		} else {
			throw new RuntimeException("Configuration error in jboss-aop.xml");
		}
	}

	/**
	 * build the message String for the logger
	 * @param mInvocation
	 * @return
	 */
	private String buildMessage(MethodInvocation invocation) {
		Object[] arguments = invocation.getArguments();
		Method method = invocation.getMethod();
		String methodName = method.getName();
		String className = method.getDeclaringClass().getName();
		String returnTypeName = method.getReturnType().getName();
		Class[] argTypes = method.getParameterTypes();
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < argTypes.length; i++) {
			buffer.append(argTypes[i].getName());
			buffer.append(" = ");
			buffer.append(arguments[i]);
			buffer.append(", ");
		} 
		String message = "invoked method: "+returnTypeName+" "+className+"."+methodName+"("+buffer.toString()+")";
		return message;
	}
}
