/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import javax.servlet.jsp.JspException;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 * @author svetrini
 * @jsp.tag name = "isValid" body-content = "empty"
 */
public class WriteTag extends org.apache.struts.taglib.bean.WriteTag {

	/* # net.smartlab.web.auth.User user */
	private static final long serialVersionUID = -605606288738918589L;
	
	/**
	 * @uml.property  name="logger"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	protected final transient Log logger = LogFactory.getLog(this.getClass());



	/**
	 * TODO documentation
	 */
	public WriteTag() {
		super.name = UserAction.SESSION_KEY;
		super.scope = "session";
	}
	
    public int doStartTag()
	    throws JspException
	{
	    if(ignore && TagUtils.getInstance().lookup(pageContext, name, scope) == null)
	        return 0;
	    String token = (String) TagUtils.getInstance().lookup(pageContext, name, scope);
	    if(token == null || "".equals(token))
	        return 0;
	    User user = User.get();
	    if (user==null)
	    	return 0;
	    Object value = null;
		try {
			value = BeanUtils.getProperty(user, property);
			if (value == null)
				return 0;
		} catch (Exception e) {
			logger.error(e);
			return 0;
		} 

	    String output = formatValue(value);
	    if(filter)
	        TagUtils.getInstance().write(pageContext, TagUtils.getInstance().filter(output));
	    else
	        TagUtils.getInstance().write(pageContext, output);
	    return 0;
	}
}
