/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.smartlab.web.ActionException;
import net.smartlab.web.BusinessException;
import net.smartlab.web.DataAccessObject.SearchInfo;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

/**
 * TODO documentation
 * 
 * @author rlogiacco@users.sourceforge.net
 */
public class UserAction extends SubjectAction {

	/**
	 * The key used to store and retrieve the user status list.
	 */
	public final static String STATUS_LIST_KEY = "user.status.list";

	/**
	 * The key used to store and retrieve the current user from session.
	 */
	public final static String SESSION_KEY = "net.smartlab.web.auth";

	/**
	 * TODO documentation Comment for <code>domain</code>
	 * @uml.property  name="domain"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	private Domain domain = Domain.getInstance();


	/**
	 * @see net.smartlab.web.AbstractArchiveAction#search(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String search(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		Collection users = domain.listUsers(super.getSearchInfo(request));
		request.setAttribute("users", users);
		return "success";
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#select(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String select(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try{
		//set in request allGroups
		SearchInfo infoAll = new SearchInfo();
		
		Collection allGroups = domain.listGroups(infoAll);
		request.setAttribute("allGroups", allGroups);
		
		
		DynaActionForm dform = (DynaActionForm) form;
		String id = dform.getString("id");
		User user = null;
		if (id==null || "".equals(id)){
			
			user = domain.findUser(""+0);
			user.setGroups(java.util.Collections.EMPTY_SET);
			
		}else{
			user = domain.findUser(id);
		}
		
		request.setAttribute("user", user);
		request.setAttribute(STATUS_LIST_KEY, User.STATUS_LIST);
		
		
		if (form != null && !super.hasErrors(request)) {
			super.reset(form, request, mapping);
			super.populate(form, user, request.getLocale());
		}
		
		

		
		
		return "success";
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#update(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String update(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		User user = domain.findUser(request.getParameter("id"));
		super.valorize(form, user, request.getLocale());
		String[] groups = super.getSelection(form, "group-selection");
		if (groups != null) {
			user.clearGroups();
			for (int i = 0; i < groups.length; i++) {
				user.add(domain.findGroup(groups[i]));
			}
		}
		// String[] roles = super.getSelection(form, "role-selection");
		// if (roles != null) {
		// user.clearRoles();
		// for (int i = 0; i < roles.length; i++) {
		// user.add(domain.findRole(roles[i]));
		// }
		// }
		domain.updateUser(user);
		return "success";
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#remove(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String remove(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		domain.removeUser(request.getParameter("id"));
		return "success";
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#removeAll(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String removeAll(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		String[] ids = super.getListSelection(request);
		for (int i = 0; i < ids.length; i++) {
			domain.removeUser(ids[i]);
		}
		return "success";
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws Exception
	 */
	public String groups(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		User user = domain.findUser(request.getParameter("id"));
		request.setAttribute("user", user);
		Collection groups = user.getGroups();
		if (super.getSelection(form, "group-selection") == null) {
			String[] selection = new String[groups.size()];
			Iterator selected = groups.iterator();
			for (int i = 0; selected.hasNext(); i++) {
				Group group = (Group)selected.next();
				selection[i] = Long.toString(group.getId());
			}
			super.setSelection(form, "group-selection", selection);
			super.resetSelection(form, "role-selection");
		}
		request.setAttribute("groups", domain.listGroups(super.getSearchInfo(request)));
		return "success";
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws Exception
	 */
	public String roles(ActionForm form, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
			throws Exception {
		User user = domain.findUser(request.getParameter("id"));
		request.setAttribute("user", user);
		String[] groups = super.getSelection(form, "group-selection");
		Set inherited = new TreeSet();
		if (groups != null) {
			for (int i = 0; i < groups.length; i++) {
				inherited.addAll(domain.findGroup(groups[i]).getPermissions());
			}
		}
		if (super.getSelection(form, "permission-selection") == null) {
			Collection permissions = new TreeSet(inherited);
			permissions.addAll(user.getPermissions());
			String[] selection = new String[permissions.size()];
			Iterator selected = permissions.iterator();
			for (int i = 0; selected.hasNext(); i++) {
				Role role = (Role)selected.next();
				selection[i] = role.getId();
			}
			super.setSelection(form, "permission-selection", selection);
		}
		request.setAttribute("inherited", inherited);
		request.setAttribute("roles", domain.listRoles(super.getSearchInfo(request)));
		return "success";
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws Exception
	 * @throws ActionException
	 */
	public ActionForward login(ActionForm form, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
			throws Exception {
		ActionForward success, failure;
		success = new ActionForward("/index.do",true);
		success.setModule("");
		failure = new ActionForward("/loginPage.do",true);
		failure.setModule("");
		
		
		DynaActionForm dform = (DynaActionForm) form;
		if (!this.logout(form, request, response, mapping).equals("success")) return failure;
		logger.info("login(username = " + request.getParameter("username") + ", password = "
				+ request.getParameter("secret") + ") - start");
		Credentials credential = new Credentials();
		//super.valorize(form, credential, request.getLocale());
		
		credential.setUsername((String) dform.get("username"));
		credential.setSecret((String) dform.get("secret"));
		
		//BeanUtils.copyProperties(credential, form);
		
		User user = domain.login(credential);
		if (user == null) {
			return failure;
		} else {
			request.getSession().setAttribute(SESSION_KEY, user.getSecurityToken());
			user.getPolicy();
			return success;
		}
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws ActionException
	 */
	public String logout(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		logger.info("logout() - start");
		try {
			User user = User.get();
			domain.logout(user.getSecurityToken());
			request.getSession().removeAttribute(SESSION_KEY);
			return "success";
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws Exception
	 */
	public String register(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		return domain.register(request.getParameterMap(), request.getParameter("step"));
	}

	/**
	 * @see net.smartlab.web.Action#cancel(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	protected ActionForward cancel(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		super.reset(form, request, mapping);
		return mapping.findForward("cancel");
	}
	

}
