/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import net.smartlab.config.Configuration;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Element;
import net.smartlab.web.DataAccessObject;
import net.smartlab.web.auth.Scope.Type;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TODO documentation
 * 
 * @author svetrini
 */
public class TypeFactory implements DataAccessObject{
	
	/**
	 * Logger for this class
	 */
	private static final Log logger = LogFactory.getLog(TypeFactory.class);
	
	private static TypeFactory instance = null;
	/**
	 * @uml.property  name="types"
	 * @uml.associationEnd  qualifier="key:java.lang.String net.smartlab.web.auth.Scope$Type"
	 */
	private Map types = new HashMap();
	
	protected TypeFactory(){
		super();
	}

	protected void init(Element config) throws ConfigurationException {
		if (config!=null){
			Iterator scopetypes = config.getElements().iterator();
			while (scopetypes.hasNext()) {
				Element scopetype = (Element)scopetypes.next();
				
				Type tmpType =  new Type(scopetype.getAttribute("id"),scopetype.getAttribute("type"));				
				String handlerClassName = scopetype.getAttribute("handler");
				if (handlerClassName!=null && !"".equals(handlerClassName.trim())){
					try {
						Class handlerClass = Class.forName(handlerClassName);						
						AuthorizationHandler handler=(AuthorizationHandler) handlerClass.newInstance();;
						Map parameters= new HashMap();
						//FIXME
//						HashMap keys = (HashMap) scopetype.getAttributeNames();
//						if (keys!=null)
//							for (Iterator iterator = keys.iterator(); iterator.hasNext();) {								
//								String name = (String) iterator.next();
//								parameters.put(name, scopetype.getAttribute(name));
//							} 						
						handler.init(parameters);
						tmpType.setHandler(handler);
					} catch (ClassNotFoundException e) {
						logger.error(e);
						throw new ConfigurationException("Handler not found "+handlerClassName);
					} catch (Exception e) {
						logger.error(e);
						throw new ConfigurationException("Handler not suitable "+handlerClassName,e);
					} 
				}
				this.types.put(scopetype.getAttribute("id"),tmpType);
				logger.info("type id: "+scopetype.getAttribute("id") + " type : "+scopetype.getAttribute("type"));
				
			}
		}
	}
	

	public static synchronized TypeFactory getInstance() {
		if (instance==null){
			instance = new TypeFactory();
			try {
				Configuration configuration = Domain.getInstance().getConfiguration();
				if (configuration != null)
					instance.init(configuration.getElement("scopetypes"));
			} catch (ConfigurationException e) {
				logger.warn("Configuration Exception ", e);
			}
		}
		return instance;
	}


	public Object findByKey(Serializable key)  {
		return (Type)types.get(key);
	}


	public Collection list(SearchInfo info)  {
		return types.entrySet();
	}


	public void remove(Object object) {
		Object key =((Type)object).getId();
		types.remove(key);
		
	}


	public void update(Object object) {
		Object key =((Type)object).getId();
		Type tmp = (Type) this.types.get(key);
		if (tmp!=null){
			this.types.remove(key);
		}
		this.types.put(key, object);
	}
	
	public Class getMappedClass() {
		return Type.class;
	}

}
