package net.smartlab.web.auth;

import java.util.Collection;

import net.smartlab.web.BusinessObjectFactory;
import net.smartlab.web.DAOException;

import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 * @author gcontartese
 */
public class SubjectFactory extends BusinessObjectFactory {
	/* # net.smartlab.web.auth.SubjectFactory */
	/**
	 * Stores the singleton <code>instance</code> for this class.
	 * @uml.property  name="instance"
	 */
	private static SubjectFactory instance;

	/**
	 * Blocks class instantiation to enforce the singleton pattern.
	 */
	private SubjectFactory() {
		super();
	}

	/**
	 * @return Returns the instance.
	 * @uml.property name="instance"
	 */
	public static synchronized SubjectFactory getInstance() {
		if (instance == null) {
			instance = new SubjectFactory();
		}
		return instance;
	}

	/**
	 * 
	 * @param display
	 * @return a Subject found by display, null otherwise.
	 */
	public Subject findByDisplay(String display) throws DAOException {
		if (logger.isDebugEnabled()) {
			logger.debug("findByDisplay(display = " + display + ") - start");
		}
		try {
			Session session = super.current();
			Query query = session.createQuery("from Subject s where s.display=:display");
			query.setString("display", display);
			Collection c = query.list();
			Subject subject = (Subject)c.iterator().next();
			if (subject != null) {
				if (logger.isTraceEnabled()) {
					logger.trace("   matching subject found");
				}
				return subject;
			} else {
				if (logger.isTraceEnabled()) {
					logger.trace("   invalid subject");
				}
				return null;
			}
		} catch (HibernateException he) {
			logger.error("findByDisplay(display = " + display + ") - error", he);
			throw new DAOException(he);
		}
	}

	/**
	 * @return <code>Subject</code> class where it'll be execute the Criteria.
	 */
	public Class getMappedClass() {
		return Subject.class;
	}

}
