/**
 * 
 */
package net.smartlab.web.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.smartlab.web.AbstractArchiveAction;
import net.smartlab.web.ActionException;
import net.smartlab.web.BusinessException;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

/**
 * @author svetrini
 *
 */
public abstract class SubjectAction extends AbstractArchiveAction {
	/**
	 * @uml.property  name="domain"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	private Domain domain = Domain.getInstance();

	
	/**
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws ActionException
	 * @throws BusinessException 
	 */
	public String permissions(ActionForm form, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
	throws ActionException, BusinessException {
		DynaActionForm dform = (DynaActionForm) form;
		String id = dform .getString("subjectId");
		
		if (id == null || "".equals(id) || "0".equals(id)) return "error";
		Subject subject = domain.findSubject(id);
		request.setAttribute("subjectId",id);
		request.setAttribute("subject", subject);
		request.setAttribute("permissions", subject.getPermissions());
		
		

		return "success";
	}
	
	

}
