/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.io.Serializable;

import net.smartlab.web.BusinessObject;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 * @author svetrini
 * @hibernate.class schema="auth" table="`scope`"
 */
public  class  Scope extends BusinessObject {

	private static final long serialVersionUID = -8988923743827669461L;

	/**
	 * TODO documentation
	 */
	public final static String ANY = "*";

	/**
	 * TODO documentation
	 * @uml.property  name="id"
	 */
	private long id;

	/**
	 * TODO documentation
	 * @uml.property  name="type"
	 * @uml.associationEnd  multiplicity="(1 1)" inverse="scope:net.smartlab.web.auth.Scope.Type"
	 */
	private Type type;



	/**
	 * @uml.property  name="typeId"
	 */
	private String typeId;

	/**
	 * TODO documentation
	 */
	public Scope() {
		super();
	}

	/**
	 * Returns the id.
	 * 
	 * @return the id.
	 * @hibernate.id column="`id`" generator-class="native"
	 * @uml.property name="id"
	 */
	public long getId() {
		return id;
	}

	/**
	 * Sets the id.
	 * 
	 * @param id
	 *            the id to set.
	 * @uml.property name="id"
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * Returns the type.
	 * 
	 * 
	 * @return the type.
	 * @uml.property name="type"
	 */
	public Type getType() {
		return type;
	}

	/**
	 * @hibernate.property  column="`type`"
	 * @return
	 * @uml.property  name="typeId"
	 */
	protected String getTypeId(){
		return typeId;
	}
	
	/**
	 * @param  typeId
	 * @uml.property  name="typeId"
	 */
	public void setTypeId(String typeId){
		this.typeId = typeId;
		if (!ANY.equals(typeId)){
			this.type = (Type) TypeFactory.getInstance().findByKey(typeId);
			if (this.type == null)
				this.type = new Type(ANY,null);	
		}else{
			this.type = new Type(ANY,null);	
		}
		
		
	}

	/**
	 * TODO documentation
	 * @author   rlogiacco
	 */
	public static class Type implements Serializable {

		/**
		 * TODO documentation
		 */
		private static final long serialVersionUID = -9180706407865725388L;

		/**
		 * TODO documentation
		 * @uml.property  name="id"
		 */
		private String id;

		/**
		 * TODO documentation
		 * @uml.property  name="type"
		 */
		private String type;

		/**
		 * Reference to an <code>AuthenticationHandler</code> which
		 * constraints <b>any</b> activity on this scope.
		 */
		private AuthorizationHandler handler;

		public Type() {
			super();
		}

		public Type(String id, String type) {
			this.id = id;
			this.type = type;
		}

		/**
		 * Returns the id.
		 * 
		 * @return the id.
		 * @uml.property name="id"
		 */
		public String getId() {
			return id;
		}

		/**
		 * Sets the id.
		 * 
		 * @param id
		 *            the id to set.
		 * @uml.property name="id"
		 */
		public void setId(String id) {
			this.id = id;
		}

		/**
		 * Returns the type.
		 * 
		 * @return the type.
		 * @uml.property name="type"
		 */
		public String getType() {
			return type;
		}

		/**
		 * Sets the type.
		 * 
		 * @param type
		 *            the type to set.
		 * @uml.property name="type"
		 */
		public void setType(String type) {
			this.type = type;
		}

		/**
		 * Returns the handler.
		 * @return  the handler
		 * @uml.property  name="handler"
		 */
		public AuthorizationHandler getHandler() {
			return handler;
		}
		
		
		/**
		 * @param handler
		 * @uml.property  name="handler"
		 */
		protected void setHandler(AuthorizationHandler handler){
			this.handler = handler;
		}


		

		/**
		 * @see java.lang.Object#equals(Object)
		 */
		public boolean equals(Object object) {
			if (!(object instanceof Type)) {
				return false;
			}
			Type rhs = (Type) object;
			return new EqualsBuilder().
					append(this.type, rhs.type).isEquals();
		}

		/**
		 * @see java.lang.Object#hashCode()
		 */
		public int hashCode() {
			return new HashCodeBuilder(-1388764441, 712274017).
					append(this.type).toHashCode();
		}

	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return new HashCodeBuilder(-27848275, 353473951).append(this.type).toHashCode();
	}
	
	/**
	 * @see net.smartlab.web.BusinessObject#getVersion()
	 * @hibernate.version
	 */
	public long getVersion() {
		return super.getVersion();
	}

	/**
	 * TODO documentation
	 * 
	 * @see java.lang.Object#equals(Object)
	 */
	public boolean equals(Object object) {
		if (!(object instanceof Scope)) {
			return false;
		}
		Scope rhs = (Scope) object;
		return new EqualsBuilder().append(
				this.type, rhs.type).isEquals();
	}

	/**
	 * TODO documentation
	 * like a <=
	 * @param scope
	 * @return
	 */
	public boolean match(Scope scope) {
		if (scope == null ) return true;
		if (ANY.equals(this.typeId)) return true;
		if (null == this.typeId) return true;		
		Type chkType = scope.getType();
		if (chkType == null) return false;
		AuthorizationHandler chkHandler = chkType.getHandler();
		if (chkHandler == null) return this.equals(scope);
		Object[] params = {this,scope};
		return chkHandler.onRequest(params);
	}

//	/**
//	 * TODO documentation
//	 * 
//	 * @param businessObject
//	 * @return
//	 * @throws BusinessException
//	 * 
//	 */
//	public static Scope generate(BusinessObject businessObject)
//			throws BusinessException {
//
//		try {
//			Scope result = new Scope();
//			Serializable objId = (Serializable) businessObject.getClass()
//					.getMethod("getId", null).invoke(businessObject, null);
//			result.key = objId;
//			Type scopeType = new Type(null, businessObject.getClass().getName());
//			result.type = scopeType;
//
//			return result;
//
//		} catch (Exception e) {
//			throw new BusinessException("exception generating scope from "
//					+ businessObject, e);
//
//		}
//	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this).append("type", this.type).toString();
	}

}
