/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import net.smartlab.config.Configuration;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Element;
import net.smartlab.web.DAOException;
import net.smartlab.web.DataAccessObject;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TODO documentation
 * 
 * @author rlogiacco@users.sourceforge.net
 */
public class RoleFactory implements DataAccessObject{
	
	
	/**
	 * Logger for this class
	 */
	private static final Log logger = LogFactory.getLog(RoleFactory.class);

	/**
	 * Stores the singleton <code>instance</code> for this class.
	 * @uml.property  name="instance"
	 */
	private static RoleFactory instance;
	

	
	/**
	 * TODO documentation
	 * @uml.property  name="roles"
	 * @uml.associationEnd  qualifier="getAttribute:java.lang.String net.smartlab.web.auth.Role"
	 */
	private Map roles = new HashMap();


	/**
	 * Blocks class instantiation to enforce the singleton pattern.
	 */
	protected RoleFactory() {
		super();
	}

	/**
	 * @return Returns the instance.
	 * @uml.property name="instance"
	 */
	public static synchronized RoleFactory getInstance() {
		if (instance == null) {
			instance = new RoleFactory();
			try {
				Configuration configuration = Domain.getInstance().getConfiguration();
				if (configuration!=null)
					instance.init(configuration.getElement("roles"));
			} catch (ConfigurationException e) {
				logger.warn("Configuration Exception ", e);
			}
		}
		return instance;
	}

	/**
	 * @see net.smartlab.web.BusinessObjectFactory#getMappedClass()
	 */
	public Class getMappedClass() {
		return Role.class;
	}
	
	/**
	 * TODO documentation
	 *
	 * @param config
	 * @throws ConfigurationException
	 */
	protected void init(Element config) throws ConfigurationException {
		Iterator roles = config.getElements().iterator();
		while (roles.hasNext()) {
			Element current = (Element)roles.next();
			Role role = new Role(current.getAttribute("id"), current.getElement("description").getContent());
			Iterator privileges = current.getElements("privilege").iterator();
			while (privileges.hasNext()) {
				Element privilege = (Element)privileges.next();
				role.add(new Privilege(privilege.getAttribute("resource"), privilege.getAttribute("element"), privilege.getAttribute("modifier"), null/*privilege.getAttribute("handler")*/));
			}
			this.roles.put(current.getAttribute("id"), role);
		}
	}

	public Role findByDisplay(String display) throws DAOException {
		if (logger.isDebugEnabled()) {
			logger.debug("findByDisplay(display = " + display + ") - start");
		}
		for (Iterator iterator = this.roles.values().iterator(); iterator.hasNext();) {
			Role role = (Role) iterator.next();
			if (role.getDisplay().equals(display)) return role;
			
		}
		return null;
	}

	public Object findByKey(Serializable key) throws DAOException {
		return this.roles.get(""+key);
		
	}

	public Collection list(SearchInfo info) throws DAOException {
		
		return this.roles.values();
	}

	public void remove(Object object) throws DAOException {
		this.roles.remove(""+((Role)object).getId());
		
	}

	public void update(Object object) throws DAOException {
		Role tmp = (Role) this.roles.get(""+((Role)object).getId()); 
		
		try {
			BeanUtils.copyProperties(tmp, ((Role)object));
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		tmp = (Role) object;
		
	}
}
