/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.smartlab.web.AbstractArchiveAction;
import net.smartlab.web.ActionException;
import net.smartlab.web.BusinessException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * TODO documentation
 * 
 * @author rlogiacco@users.sourceforge.net
 */
public class RoleAction extends AbstractArchiveAction {

	/**
	 * @uml.property  name="domain"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	private Domain domain = Domain.getInstance();


	/**
	 * @see net.smartlab.web.AbstractArchiveAction#search(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String search(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			Collection roles = domain.listRoles(super.getSearchInfo(request));
			request.setAttribute("roles", roles);
			return "success";
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#select(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String select(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			Role role = domain.findRole(request.getParameter("id"));
			request.setAttribute("role", role);
			if (form != null && !super.hasErrors(request)) {
				super.reset(form, request, mapping);
				super.populate(form, role, request.getLocale());
			}
			return "success";
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#remove(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String remove(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			domain.removeRole(request.getParameter("id"));
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
		return "success";
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#removeAll(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String removeAll(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			String[] ids = super.getListSelection(request);
			for (int i = 0; i < ids.length; i++) {
				domain.removeRole(ids[i]);
			}
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
		return "success";
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws ActionException
	 */
	public String groups(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			Role role = domain.findRole(request.getParameter("id"));
			request.setAttribute("role", role);
			Collection groups = null; // FIXME role.getGroups();
			if (super.getSelection(form, "group-selection") == null) {
				String[] selection = new String[groups.size()];
				Iterator selected = groups.iterator();
				for (int i = 0; selected.hasNext(); i++) {
					Group group = (Group)selected.next();
					selection[i] = Long.toString(group.getId());
				}
				super.setSelection(form, "group-selection", selection);
			}
			request.setAttribute("groups", domain.listGroups(super.getSearchInfo(request)));
			return "success";
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

	/**
	 * @see net.smartlab.web.Action#cancel(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	protected ActionForward cancel(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		super.reset(form, request, mapping);
		return mapping.findForward("cancel");
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#update(org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionMapping)
	 * @throws UnsupportedOperationException
	 */
	public String update(ActionForm form, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws Exception {
		throw new UnsupportedOperationException();
	}
}
