/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import net.smartlab.web.BusinessObject;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author rlogiacco
 */
public class Role extends BusinessObject {

	private final static long serialVersionUID = -4503232852862828231L;

	/**
	 * @uml.property  name="id"
	 */
	private String id;

	/**
	 * @uml.property  name="display"
	 */
	private String display;

	/**
	 * @uml.property  name="privileges"
	 * @uml.associationEnd  multiplicity="(0 -1)" inverse="role:net.smartlab.web.auth.Privilege"
	 */
	private Set privileges = new HashSet();

	/**
	 * Reference to an <code>Handler</code> which constraints <b>any</b> activity performed by <b>any</b> user binded to this role.
	 * @uml.property  name="handler"
	 * @uml.associationEnd  inverse="role:net.smartlab.web.auth.AuthorizationHandler"
	 */
	private String handler;

	/**
	 * TODO documentation
	 */
	public Role() {
		super();
	}

	/**
	 * TODO documentation
	 * 
	 * @param display
	 */
	public Role(String display) {
		super();
		this.display = display;
		this.id=display;
	}

	/**
	 * TODO documentation
	 * 
	 * @param id
	 * @param display
	 */
	public Role(String id, String display) {
		super();
		this.id=id;
		this.display = display;
	}

	/**
	 * @return
	 * @uml.property name="id"
	 */
	public String getId() {
		return id;
	}

	public boolean hasPrivilege(Privilege privilege){
		
		for (Iterator iterator = this.privileges.iterator(); iterator.hasNext();) {
			Privilege priv = (Privilege) iterator.next();
			
			if (this.handler==null){
				if (privilege.match(priv)) return true;
			}else{
				//FIXME manage handler
				
			}
			
			
		}
		return false;
	}

	/**
	 * @param id
	 * @uml.property name="id"
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Returns the display name.
	 * 
	 * @return the display name.
	 * @hibernate.property column="`display`" length="50" not-null="true"
	 *                     unique="true"
	 * @uml.property name="display"
	 */
	public String getDisplay() {
		return display;
	}

	/**
	 * @param display
	 * @uml.property name="display"
	 */
	public void setDisplay(String display) {
		this.display = display;
	}

	/**
	 * @uml.property name="privileges"
	 */
	public Set getPrivileges() {
		return privileges;
	}

	/**
	 * @uml.property name="privileges"
	 */
	public void setPrivileges(Set privileges) {
		this.privileges = privileges;
	}

	/**
	 * TODO documentation
	 * 
	 * @param privilege
	 */
	public void add(Privilege privilege) {
		this.privileges.add(privilege);
	}

	/**
	 * TODO documentation
	 * 
	 * @param privilege
	 */
	public void remove(Privilege privilege) {
		this.privileges.remove(privilege);
	}

	/**
	 * Returns the handler.
	 * 
	 * @return the handler
	 * @uml.property name="handler"
	 */
	public String getHandler() {
		return handler;
	}

	/**
	 * Sets the handler.
	 * 
	 * @param handler
	 *            the handler to set
	 * @uml.property name="handler"
	 */
	public void setHandler(String handler) {
		this.handler = handler;
	}

	/**
	 * @see java.lang.Object#equals(Object)
	 */
	public boolean equals(Object object) {
		if (!(object instanceof Role)) {
			return false;
		}
		Role rhs = (Role) object;
		return new EqualsBuilder().append(this.display,
				rhs.display).isEquals();
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return new HashCodeBuilder(-1581106485, 1793215057).append(this.display)
				.toHashCode();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this).append("display",
						this.display).toString();
	}

	



	
}
