/*
 * The SmartWeb Framework
 * Copyright (C) 20042006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  021101301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.util.Map;

/**
 * Defines an interface to introduce custom controls and actions into the
 * registration process at a business level.
 * 
 * @author svetrini
 * @author pmoretti
 * @author rlogiacco
 */
public interface RegistrationHandler extends Handler {

	/**
	 * This method is invoked while the user creation is in progress meaning the
	 * user could have already obtained a unique identifier. Implementations can
	 * process custom properties and create linked informations and structures.
	 * For multi step registration procedures an optional step parameter can be
	 * used to distinguish between each step.
	 * 
	 * FIXME documentation
	 * 
	 * @param user the user just registered.
	 * @param props additional properties not directly managed by the module.
	 * @param step indicates the internal handler status to be used for multi
	 *        step registration procedures.
	 * @return the next step to be processed.
	 * @throws Exception if the registration couldn't be performed for some
	 *         reason described into the exception message.
	 */
	public String onRegister(Map props, String step) throws Exception;

	/**
	 * This method is invoked before a request of user informations update is
	 * performed. implementations should verify the ongoing changes doesn't
	 * break any business or security constraint. For multi step update
	 * procedures an optional step parameter can be used to distinguish between
	 * each step.
	 * 
	 * @param user the user already updated but not yet committed.
	 * @param props additional properties not directly managed by the module.
	 * @param step indicates the internal handler status to be used for multi
	 *        step registration procedures.
	 * @return the next step to be processed.
	 * @throws Exception if the update shouldn't be performed for some reason
	 *         described into the exception message.
	 */
	public String onUpdate(User user, Map props, String step) throws Exception;
}
