/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import net.smartlab.web.BusinessObject;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TODO documentation
 * @author   rlogiacco
 * @author   svetrini
 * @uml.stereotype  uml_id="Standard::Type" 
 */
public class Privilege extends BusinessObject implements Comparable , Cloneable{

	private static final long serialVersionUID = 5093513127253605079L;

	/**
	 * @uml.property  name="logger"
	 * @uml.associationEnd  
	 */
	protected final Log logger = LogFactory.getLog(Privilege.class);
	
	/**
	 * TODO documentation
	 */
	public final static byte ANY = 0x00;
	public final static char CHAR_ANY = '*';
	public final static String STRING_ANY = "*";

	/**
	 * TODO documentation
	 */
	public final static byte READ = 0x01;
	public final static char CHAR_READ = 0x01;

	/**
	 * TODO documentation
	 */
	public final static byte WRITE = 0x02;
	public final static char CHAR_WRITE = 0x02;

	/**
	 * TODO documentation
	 */
	public final static byte EXECUTE = 0x04;
	public final static char CHAR_EXECUTE = 0x04;

	/**
	 * TODO documentation
	 * @uml.property  name="resource"
	 */
	private String resource;

	/**
	 * TODO documentation
	 * @uml.property  name="element"
	 */
	private String element;

	/**
	 * TODO documentation
	 * @uml.property  name="modifier"
	 */
	private byte modifier;

	/**
	 * TODO documentation
	 * @uml.property  name="handler"
	 */
	private String handler;

	/**
	 * TODO documentation
	 */
	public Privilege() {
		super();
	}

	/**
	 * TODO documentation
	 * 
	 * @param resource
	 * @param element
	 * @param modifier
	 */
	public Privilege(String resource, String element, byte modifier) {
		this.resource = resource;
		this.element = element;
		this.modifier = modifier;
	}
	
	/**
	 * TODO documentation
	 * 
	 * @param resource
	 * @param element
	 * @param modifier
	 */
	public Privilege(String resource, String element, String modifier) {
		this(resource, element, modifier, null);
	}
	
	/**
	 * TODO documentation
	 * 
	 * @param resource
	 * @param element
	 * @param modifier
	 */
	public Privilege(String resource, String element, String modifier, String handler) {
		this(resource, element, (byte)0);
		this.setModifier(modifier);
		this.handler = handler;
	}

	/**
	 * Returns the resource.
	 * @return  the resource
	 * @uml.property  name="resource"
	 */
	public String getResource() {
		return resource;
	}

	/**
	 * Sets the resource.
	 * @param resource  the resource to set
	 * @uml.property  name="resource"
	 */
	public void setResource(String resource) {
		if (resource == null) resource = "";
		this.resource = resource;
	}

	/**
	 * Returns the element.
	 * @return  the element
	 * @uml.property  name="element"
	 */
	public String getElement() {
		return element;
	}

	/**
	 * Sets the element.
	 * @param element  the element to set
	 * @uml.property  name="element"
	 */
	public void setElement(String element) {
		if (element == null) element = "";
		this.element = element;
	}

	/**
	 * Returns the modifier.
	 * @return  the modifier
	 * @uml.property  name="modifier"
	 */
	public byte getModifier() {
		return modifier;
	}

	/**
	 * Sets the modifier.
	 * @param modifier  the modifier to set
	 * @uml.property  name="modifier"
	 */
	public void setModifier(byte modifier) {
		this.modifier = modifier;
	}

	/**
	 * Sets the modifier.
	 * 
	 * @param modifier the modifier to set
	 */
	public void setModifier(String modifier) {
		if (modifier == null) modifier = "";
		if (modifier.indexOf(CHAR_ANY) >= 0) {
			this.modifier = ANY;
		}
		else{
			char[] chars = modifier.toCharArray();
			for (int i = 0; i < chars.length; i++) {
				switch (chars[i]) {
					case 'r':
					case 'R':
					case CHAR_READ:	
						this.modifier += READ;
						break;
					case 'w':
					case 'W':
					case CHAR_WRITE:	
						this.modifier += WRITE;
						break;
					case 'x':
					case 'X':
					case CHAR_EXECUTE:
						this.modifier += EXECUTE;
						break;			
					default:
					logger.warn("Invalid access modifier: " + chars[i]);
				}
			}
		}
	}
	
	/**
	 * @return
	 * @uml.property  name="handler"
	 */
	public String getHandler() {
		
		return handler;
	}

	
	/**
	 * @param handler
	 * @uml.property  name="handler"
	 */
	public void setHandler(String handler) {
		if (handler == null) handler = "";
		this.handler = handler;
	}

	/**
	 * Verifies if the specified privilege represents a match for this one.
	 * like a <=
	 * @param privilege the privilege to compare.
	 */
	public boolean match(Privilege privilege) {
		if (privilege.resource.equals(this.resource) || privilege.resource.equals(STRING_ANY)) {
			if (privilege.element.equals(this.element) || privilege.element.equals(STRING_ANY)) {
				if ((privilege.modifier & this.modifier) >= this.modifier) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return new HashCodeBuilder(-910312141, -1655346559).append(this.modifier).append(this.element)
				.append(this.resource).toHashCode();
	}

	/**
	 * @see java.lang.Object#equals(Object)
	 */
	public boolean equals(Object object) {
		if (!(object instanceof Privilege)) {
			return false;
		}
		Privilege rhs = (Privilege) object;
		return new EqualsBuilder().append(
				this.modifier, rhs.modifier).append(this.element, rhs.element)
				.append(this.resource, rhs.resource).isEquals();
	}

	/**
	 * @see java.lang.Comparable#compareTo(Object)
	 */
	public int compareTo(Object object) {
		Privilege myClass = (Privilege) object;
		return new CompareToBuilder().append(this.modifier, myClass.modifier)
				.append(this.element, myClass.element).append(this.resource,
						myClass.resource).toComparison();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this).append("element", this.element)
				.append("resource", this.resource).append("modifier", this.modifier)
				.toString();
	}
	
	protected Object clone() throws CloneNotSupportedException {
		Privilege cloned;
		try {
			cloned = (Privilege) BeanUtils.cloneBean(this);
		} catch (Exception e) {
			logger.error(e);
			throw new CloneNotSupportedException(e.getMessage());
		} 
		return cloned;
		
	}


}
