/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import net.smartlab.web.BusinessObjectFactory;
import net.smartlab.web.DAOException;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;

/**
 * @author rlogiacco
 * @author svetrini
 */
public class PermissionFactory extends BusinessObjectFactory {

	/**
	 * Stores the singleton <code>instance</code> for this class.
	 * @uml.property  name="instance"
	 */
	private static PermissionFactory instance;


	/**
	 * Blocks class instantiation to enforce the singleton pattern.
	 */
	private PermissionFactory() {
		super();
	}

	/**
	 * @return Returns the instance.
	 * @uml.property name="instance"
	 */
	public static synchronized PermissionFactory getInstance() {
		if (instance == null) {
			instance = new PermissionFactory();
		}
		return instance;
	}

	/**
	 * @see net.smartlab.web.BusinessObjectFactory#getMappedClass()
	 */
	public Class getMappedClass() {
		return Permission.class;
	}
	public Collection listPolicyByUserId(String idUser) throws DAOException {
		if (logger.isDebugEnabled()) {
			logger.debug("listPolicyByUserId(idUser +" +idUser + ") - start");
		}
		try{
			Collection first=null;
			Collection second = null;
			Session session=super.current();
			Criteria criteria=session.createCriteria(this.getMappedClass());
			criteria.add(Expression.eq("subject.id",new Long(Long.parseLong(idUser))));
			first= criteria.list();	
			String hq="select p from User as u left join u.groups as g left join g.permissions as p where u.id=:userId";
			Query query=session.createQuery(hq);
			query.setLong("userId", Long.parseLong(idUser));
			second=query.list();
			if(second!=null && second.size()>0)
				first.addAll(second);
			return first;
		}catch(HibernateException he){
			String error="listUserPolicyById(idUser = " + idUser + ") - CAUSE :"+he.getMessage();
			logger.error(error);
			throw new DAOException(he);
		}
	}
	
	
	public Set listPolicy(String idUser) throws DAOException{
		if (logger.isDebugEnabled()) {
			logger.debug("getPolicyByUser(User = " + idUser + ") - start");
		}
		Set result = new HashSet();
		try {
			Session session = super.current();
			String strQuery = 
			"select distinct p.\"id\" " +
			"from " +
			"auth.\"permission\" as p, " +
			"auth.\"group\" as g, " +
			"auth.\"group_user\" as gu, " +
			"auth.\"user\" as u " +
			"where  " +
			"( p.\"subject\" = ? AND p.\"subject\" = u.\"id\" ) " +
			"OR " +
			"( u.\"id\" = ? and u.\"id\"=gu.\"user\" and g.\"id\" = gu.\"group\" and p.\"subject\" = g.\"id\")";
			SQLQuery sqlQuery = session.createSQLQuery(strQuery);
			sqlQuery.setLong(0, Long.parseLong(idUser));
			sqlQuery.setLong(1, Long.parseLong(idUser));

			List permissionId = sqlQuery.list();			
			for (Iterator iterator = permissionId.iterator(); iterator
					.hasNext();) {
				
				Object tmp = findByKey((Serializable) iterator.next());
				if (tmp!=null){
					result.add(tmp);
				}
			}
			return result;
		} catch (HibernateException he) {
			logger.error("getPolicyByUser(User = " + idUser + ") - error", he);
			throw new DAOException(he);
		}
		
	}
	
	public Object findByKey(Serializable key) throws DAOException {
		Permission p = (Permission) super.findByKey(key);
		if (p!=null){
			p.getScope();
			p.getSubject();
		}
		return p;
	}
}
