/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.util.Collection;
import java.util.Collections;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.smartlab.web.AbstractArchiveAction;
import net.smartlab.web.ActionException;
import net.smartlab.web.BusinessException;
import net.smartlab.web.DataAccessObject.SearchInfo;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

/**
 * @author svetrini
 * 
 */
public class PermissionAction extends AbstractArchiveAction {

	/**
	 * TODO documentation Comment for <code>domain</code>
	 * @uml.property  name="domain"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	private Domain domain = Domain.getInstance();

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.smartlab.web.AbstractArchiveAction#remove(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String remove(ActionForm form, HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping)
			throws Exception {
		request.setAttribute("subject", domain.findPermission(request.getParameter("subjectId")).getSubject());
		domain.removePermission(request.getParameter("id"));
		
		return "success";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.smartlab.web.AbstractArchiveAction#removeAll(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String removeAll(ActionForm form, HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping)
			throws Exception {
		String[] ids = super.getListSelection(request);
		if (ids.length>0){
			request.setAttribute("subject", domain.findPermission(ids[0]).getSubject());
		}else{
			return "cancel";
		}		
		
		for (int i = 0; i < ids.length; i++) {
			domain.removePermission(ids[i]);
		}
		return "success";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.smartlab.web.AbstractArchiveAction#search(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String search(ActionForm form, HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping)
			throws Exception {
		Collection permissions = domain.listPermissions(super
				.getSearchInfo(request));
		request.setAttribute("permissions", permissions);
		return "success";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.smartlab.web.AbstractArchiveAction#select(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String select(ActionForm form, HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping)
			throws ActionException {
		DynaActionForm dform = (DynaActionForm) form;
		Collection allRoles = Collections.EMPTY_SET;
		try {
			allRoles = domain.listRoles(new SearchInfo());
		} catch (BusinessException e) {
			
			e.printStackTrace();
		}
		String id = dform.getString("id");
		String subjectId =  dform.getString("subjectId");
		Subject subject = null;
				
		Permission permission = null;
		try {
			subject = (Subject) domain.findSubject(subjectId);
			if (id==null || "".equals(id)){
				
				permission = domain.findPermission(""+0);
				
			}else{
				
				permission = domain.findPermission(id);
			}
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
		

		request.setAttribute("permission", permission);
		request.setAttribute("subject", subject);
		request.setAttribute("allRoles", allRoles);
		request.setAttribute("subject-id", subjectId);


		return "success";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.smartlab.web.AbstractArchiveAction#update(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String update(ActionForm form, HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping)
			throws Exception {
		try {
			DynaActionForm dform = (DynaActionForm) form;
			String permissionId=request.getParameter("id");
			String subjectId = dform.getString("subjectId");
			String roleId = dform.getString("role-id");
			Role role = domain.findRole(roleId);
			Subject subject = domain.findSubject(subjectId);
			request.setAttribute("subject", subject);
			if (permissionId == null || "".equals(permissionId)){
				permissionId = "0";
			}
			Permission permission = domain.findPermission(permissionId);
			permission.setSubject(subject);
			permission.setRoleId(role.getId());
			domain.updatePermission(permission);
			request.setAttribute("permission", permission);
			request.setAttribute("permission", permission);
			

			String success="success";
			if (subject instanceof User) {
				success=success+"-user";				
			}else if(subject instanceof Group){
				success=success+"-group";
			}
			return success;
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

}
