/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import net.smartlab.web.BusinessObject;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * TODO documentation
 * 
 * @author svetrini
 * @author rlogiacco
 * @hibernate.class schema="auth" table="`permission`" 
 */
public final class Permission extends BusinessObject implements Cloneable {

	private static final long serialVersionUID = -4074180118048290779L;

	/**
	 * TODO documentation
	 * @uml.property  name="id"
	 */
	private long id;

	/**
	 * TODO documentation
	 * @directed   true
	 * @uml.property  name="roleId"
	 */
	private String roleId="";

	/**
	 * TODO documentation
	 * @directed   true
	 * @uml.property  name="subject"
	 * @uml.associationEnd  multiplicity="(1 1)" inverse="permissions:net.smartlab.web.auth.Subject"
	 */
	private Subject subject = null;

	/**
	 * TODO documentation
	 * @directed   true
	 * @uml.property  name="scope"
	 * @uml.associationEnd  inverse="permission:net.smartlab.web.auth.Scope"
	 */
	private Scope scope = null;

	/**
	 * TODO documentation
	 * @directed   true
	 * @uml.property  name="handler"
	 * @uml.associationEnd  inverse="permission:net.smartlab.web.auth.AuthorizationHandler"
	 */
	private String handler;

	

	/**
	 * TODO documentation
	 */
	public Permission() {
		super();
	}

	/**
	 * Returns the id.
	 * 
	 * @return the id.
	 * @hibernate.id column="`id`" unsaved-value="0" generator-class="native"
	 * @uml.property name="id"
	 */
	public long getId() {
		return id;
	}

	/**
	 * Sets the id.
	 * 
	 * @param id
	 *            the id to set.
	 * @uml.property name="id"
	 */
	protected void setId(long id) {
		this.id = id;
	}

	/**
	 * Returns the subject.
	 * 
	 * @return the subject.
	 * @hibernate.many-to-one column="`subject`" update="false"
	 * @uml.property name="subject"
	 */
	public Subject getSubject() {
		return subject;
	}

	/**
	 * Sets the subject.
	 * 
	 * @param subject
	 *            the principal to set.
	 * @uml.property name="subject"
	 */
	public void setSubject(Subject subject) {
//		if (this.subject != null) {
//			this.subject.remove(this);
//		}
		this.subject = subject;
//		subject.add(this);
	}

	/**
	 * Returns the scope.
	 * 
	 * @return the scope.
	 * @hibernate.many-to-one column="`scope`" update="false"
	 * @uml.property name="scope"
	 */
	public Scope getScope() {
		return scope;
	}

	/**
	 * Sets the scope.
	 * 
	 * @param scope
	 *            the scope to set.
	 * @uml.property name="scope"
	 */
	public void setScope(Scope scope) {
		this.scope = scope;
	}

	/**
	 * Returns the handler.
	 * 
	 * @return the handler.
	 * @hibernate.property column="`handler`"
	 * @uml.property name="handler"
	 */
	public String getHandler() {
		return handler;
	}

	/**
	 * Sets the handler.
	 * 
	 * @param handler
	 *            the handler to set.
	 * @uml.property name="handler"
	 */
	public void setHandler(String handler) {
		this.handler = handler;
	}

	/**
	 * TODO documentation
	 * 
	 * @return
	 * @hibernate.property column="`roleId`"
	 * @uml.property name="roleId"
	 */
	
	public String getRoleId(){
		return this.roleId;
	}
	
	/**
	 * @param role
	 * @uml.property  name="roleId"
	 */
	public void setRoleId(String role){
		this.roleId=role;
	}
	
	

	/**
	 * @see net.smartlab.web.BusinessObject#getVersion()
	 * @hibernate.version
	 */
	public long getVersion() {
		return super.getVersion();
	}

	/**
	 * @see java.lang.Object#equals(Object)
	 */
	public boolean equals(Object object) {
		if (!(object instanceof Permission)) {
			return false;
		}
		
		Permission rhs = (Permission) object;
		return new EqualsBuilder().append(this.subject, rhs.subject).append(this.roleId, rhs.roleId).append(this.scope, rhs.scope).isEquals();
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {		
		return new HashCodeBuilder(1683017233, 1682367525).append(this.roleId).append(this.subject).append(this.scope)
				.toHashCode();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this).append("roleId", this.roleId).append(
				"scope", this.scope).toString();
	}
	
	protected Object clone() throws CloneNotSupportedException {
		Permission cloned;
		try {
			cloned = (Permission) BeanUtils.cloneBean(this);
		} catch (Exception e) {
			logger.error(e);
			throw new CloneNotSupportedException(e.getMessage());
		} 
		return cloned;
		
	}

}
