/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import javax.servlet.jsp.JspException;

/**
 * Inverts the behaviour of <code>ValidTag</code>.
 * 
 * @see net.smartlab.web.auth.ValidTag
 * @author rlogiacco
 * @jsp.tag name = "notValid" description="checks if a user was not previously
 *          authenticated or is not authorized by a role" body-content="JSP"
 */
public class NotValidTag extends ValidTag {

	private static final long serialVersionUID = -7799866666650438550L;


	/**
	 * Default empty constructor.
	 */
	public NotValidTag() {
		super();
	}

	/**
	 * @see org.apache.struts.taglib.logic.ConditionalTagBase#condition()
	 */
	protected boolean condition() throws JspException {
		return (condition(false));
	}
}
