/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.util.Map;

import net.smartlab.config.ConfigurationException;

/**
 * @author rlogiacco
 */
public interface Handler {

	/**
	 * Returns the handler unique identifier.
	 * 
	 * @return the handler unique identifier.
	 */
	public String getId();
	
	/**
	 * Sets the handler unique identifier.
	 *
	 * @param id the handler unique identifier.
	 */
	public void setId(String id);

	/**
	 * This method initializes the handler providing any parameter specified in
	 * the configuration.
	 * 
	 * @param parameters any parameter name-value pair providen at configuration
	 *        time
	 * @throws ConfigurationException if something unexpected happens during handler
	 *         initialization
	 */
	public void init(Map parameters) throws Exception;

	/**
	 * Allows resources clean up happens before the handler is marked for
	 * garbage collection.
	 * 
	 * @throws Exception if something unexpected happens while releasing
	 *         resources.
	 */
	public void destroy() throws Exception;
	
}
