/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.util.Collection;
import java.util.Iterator;

import net.smartlab.web.BusinessObjectFactory;
import net.smartlab.web.DAOException;

/**
 * TODO documentation
 * 
 * @author rlogiacco@users.sourceforge.net
 */
public class GroupFactory extends BusinessObjectFactory {

	/* # net.smartlab.web.auth.Group bo */
	/**
	 * Stores the singleton <code>instance</code> for this class.
	 * @uml.property  name="instance"
	 */
	private static GroupFactory instance;


	/**
	 * Blocks class instantiation to enforce the singleton pattern.
	 */
	private GroupFactory() {
		super();
	}

	/**
	 * @return Returns the instance.
	 * @uml.property name="instance"
	 */
	public static synchronized GroupFactory getInstance() {
		if (instance == null) {
			instance = new GroupFactory();
		}
		return instance;
	}

	/**
	 * @see net.smartlab.web.BusinessObjectFactory#getMappedClass()
	 */
	public Class getMappedClass() {
		return Group.class;
	}
	
	public Collection list(SearchInfo info) throws DAOException {
		
		Collection groups= super.list(info);
		for (Iterator iterator = groups.iterator(); iterator.hasNext();) {
			Group group = (Group) iterator.next();
			group.getPermissions();
			group.getUsers();
			
		}
		return groups;
	}
}
