/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.smartlab.web.ActionException;
import net.smartlab.web.BusinessException;
import net.smartlab.web.DataAccessObject.SearchInfo;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

/**
 * TODO documentation
 * 
 * @author rlogiacco@users.sourceforge.net
 */
public class GroupAction extends SubjectAction {

	/**
	 * @uml.property  name="domain"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	private Domain domain = Domain.getInstance();


	/**
	 * @see net.smartlab.web.AbstractArchiveAction#search(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String search(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			Collection groups = domain.listGroups(super.getSearchInfo(request));
			request.setAttribute("groups", groups);
			return "success";
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#select(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String select(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			
			//set in request allGroups
			SearchInfo infoAll = new SearchInfo();
			
			Collection allUsers = domain.listUsers(infoAll);
			request.setAttribute("allUsers", allUsers);
			
			DynaActionForm dform = (DynaActionForm) form;
			String id = dform.getString("id");
			
			Group group = null;
			if (id==null || "".equals(id)){
				
				group = domain.findGroup(""+0);
				group.setUsers(java.util.Collections.EMPTY_SET);
				
			}else{
				group = domain.findGroup(request.getParameter("id"));
			}
			
			request.setAttribute("group", group);
			if (form != null && !super.hasErrors(request)) {
				super.reset(form, request, mapping);
				super.populate(form, group, request.getLocale());
			}
			return "success";
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#update(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String update(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		 try {
		 Group group = domain.findGroup(request.getParameter("id"));
		 super.valorize(form, group, request.getLocale());
		 
		 
		 String[] users = super.getSelection(form, "user-selection");
		 if (users != null) {
		 group.clearUsers();
		 for (int i = 0; i < users.length; i++) {
		 group.add(domain.findUser(users[i]));
		 }
		 }
		 domain.updateGroup(group);
		return "success";
		 } catch (BusinessException be) {
		 throw new ActionException(be.getMessage(), be.getCause());
		 }
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#remove(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String remove(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			domain.removeGroup(request.getParameter("id"));
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
		return "success";
	}

	/**
	 * @see net.smartlab.web.AbstractArchiveAction#removeAll(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	public String removeAll(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws ActionException {
		try {
			String[] ids = super.getListSelection(request);
			for (int i = 0; i < ids.length; i++) {
				domain.removeGroup(ids[i]);
			}
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
		return "success";
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws ActionException
	 */
	public String roles(ActionForm form, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
			throws ActionException {
		// try {
		// Group group = domain.findGroup(request.getParameter("id"));
		// request.setAttribute("group", group);
		// Collection roles = group.getRoles();
		// if (super.getSelection(form, "role-selection") == null) {
		// String[] selection = new String[roles.size()];
		// Iterator selected = roles.iterator();
		// for (int i = 0; selected.hasNext(); i++) {
		// Role role = (Role)selected.next();
		// selection[i] = Long.toString(role.getId());
		// }
		// super.setSelection(form, "role-selection", selection);
		// super.resetSelection(form, "user-selection");
		// }
		// request.setAttribute("roles",
		// domain.listRoles(super.getSearchInfo(request)));
		return "success";
		// } catch (BusinessException be) {
		// throw new ActionException(be.getMessage(), be.getCause());
		// }
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws ActionException
	 */
	public String users(ActionForm form, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
			throws ActionException {
		try {
			Group group = domain.findGroup(request.getParameter("id"));
			request.setAttribute("group", group);
			Collection users = group.getUsers();
			if (super.getSelection(form, "user-selection") == null) {
				String[] selection = new String[users.size()];
				Iterator selected = users.iterator();
				for (int i = 0; selected.hasNext(); i++) {
					User user = (User)selected.next();
					selection[i] = Long.toString(user.getId());
				}
				super.setSelection(form, "user-selection", selection);
			}
			request.setAttribute("users", domain.listUsers(super.getSearchInfo(request)));
			return "success";
		} catch (BusinessException be) {
			throw new ActionException(be.getMessage(), be.getCause());
		}
	}

	/**
	 * @see net.smartlab.web.Action#cancel(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	protected ActionForward cancel(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		super.reset(form, request, mapping);
		return mapping.findForward("cancel");
	}
	

	
}
