/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

/**
 * Implementors of this interface are allowed to take control over the
 * authorization procedure if configured properly. The lifecicle of
 * AuthorizationHandlers is clearly stated: they get <i>inited</i> then
 * multiple calls to the <i>authorize</i> method can be performed and finally
 * they get <i>destroyed</i> just before finalization.
 * 
 * @author rlogiacco
 * @author svetrini
 */
public interface AuthorizationHandler extends Handler {

	/**
	 * TODO documentation
	 * 
	 * @param user
	 * @param role
	 * @param scope
	 * @param parameters
	 * @return
	 * @throws AuthorizationException
	 */
	public boolean onRequest(Object[] params);
}
