/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import net.smartlab.web.BusinessException;

/**
 * Thrown whenever the authentication credentials of a user fails to be
 * validated.
 * 
 * @author rlogiacco
 */
public class AuthenticationException extends BusinessException {

	private final static long serialVersionUID = -4644275466631765357L;


	/**
	 * Default empty constructor.
	 */
	public AuthenticationException() {
		super();
	}

	/**
	 * Constructs a new instance with the specified describing message.
	 * 
	 * @param message the description of the occurred exception.
	 */
	public AuthenticationException(String message) {
		super(message);
	}

	/**
	 * Constructs a new instance with the specified cause.
	 * 
	 * @param cause the <code>throwable</code> instance wich generated this
	 *        exception.
	 */
	public AuthenticationException(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructs a new instance with the specified describing message and
	 * cause.
	 * 
	 * @param message the description of the occurred exception.
	 * @param cause the <code>throwable</code> instance wich generated this
	 *        exception.
	 */
	public AuthenticationException(String message, Throwable cause) {
		super(message, cause);
	}
}
