/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TODO documentation
 * 
 * @author rlogiacco
 * @web.filter name = "action"
 * @web.filter-mapping url-pattern = "*.do"
 * @web.filter-mapping url-pattern = "*.jsp"
 */
public class ActionFilter implements Filter {

	/* # net.smartlab.web.ActionServlet front-controller */
	/* # net.smartlab.web.auth.User user */
	/**
	 * TODO documentation Comment for <code>context</code>
	 * @uml.property  name="context"
	 * @uml.associationEnd  
	 */
	protected ServletContext context;
	/**
	 * Logger for this class
	 */
	private static final Log logger = LogFactory.getLog(ActionFilter.class);


	/**
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig config) throws ServletException {
		this.context = config.getServletContext();
	}

	/**
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest,
	 *      javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException,
			IOException {
		HttpSession session = ((HttpServletRequest)request).getSession();
		String securityToken = null;
		try {
			securityToken = (String)session.getAttribute(UserAction.SESSION_KEY);
			if (securityToken == null || "".equals(securityToken)){
				securityToken = User.GUEST.getSecurityToken();				
			}
			Domain.setUser(securityToken);
			session.setAttribute(UserAction.SESSION_KEY, securityToken);
		}catch (AuthenticationException e) {
			if (logger.isDebugEnabled()) {
				logger.trace("User retrieve failure. cause: " , e);
			}
			session.removeAttribute(UserAction.SESSION_KEY);
		} finally {			
			chain.doFilter(request, response);
		}
	}

	/**
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
		// Do nothing
	}
}