/*
 * The SmartWeb Framework
 * Copyright (C) 2004-2006
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * For further informations on the SmartWeb Framework please visit
 *
 *                        http://smartweb.sourceforge.net
 */
package net.smartlab.web.auth;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import net.smartlab.web.ActionException;
import net.smartlab.web.BusinessException;
import net.smartlab.web.DynaAction;

/**
 * TODO documentation
 * 
 * @author rlogiacco@users.sourceforge.net
 */
public abstract class AbstractUserAction extends DynaAction {

	/**
	 * Logger for this class
	 * @uml.property  name="logger"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	protected final Log logger = LogFactory.getLog(AbstractUserAction.class);

	/**
	 * The key used to store and retrieve the current user from session.
	 */
	//public final static String SESSION_KEY = "net.smartlab.web.auth";

	/**
	 * Buffered <code>Domain</code> instance.
	 * @uml.property  name="domain"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	protected Domain domain = Domain.getInstance();


	/**
	 * TODO documentation
	 * 
	 * @param request
	 * @return
	 */
	public static User getUser(HttpServletRequest request) {
		return User.get();
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws BusinessException
	 * @throws ActionException
	 */
	public String register(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws BusinessException, ActionException {
		User user = AbstractUserAction.getUser(request);
		if (user != null) {
			super.valorize(form, user, request.getLocale());
			this.setGroups(user);
			this.setRoles(user);
			domain.updateUser(user);
			return "success";
		}
		throw new ActionException("");
	}

	/**
	 * TODO documentation
	 * 
	 * @param user
	 */
	protected abstract void setRoles(User user);

	/**
	 * TODO documentation
	 * 
	 * @param user
	 */
	protected abstract void setGroups(User user);

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws Exception
	 * @throws BusinessException
	 */
	public String login(ActionForm form, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
			throws Exception {
		this.logout(form, request, response, mapping);
		if (logger.isDebugEnabled()) {
			logger.debug("login(username = " + request.getParameter("username") + ") - start");
		}
		Credentials credentials = new Credentials();
		super.valorize(form, credentials, null);
		User user = domain.login(credentials);
		if (user == null) {
			return "failure";
		} else {
			request.getSession().setAttribute(UserAction.SESSION_KEY, user.getSecurityToken());
			if (request.getParameter("remember") != null) {
				Cookie cookie = new Cookie("smartweb-auth", credentials.toString());
				cookie.setMaxAge(15 * 24 * 60 * 60);
				response.addCookie(cookie);
			}
			return "success";
		}
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws Exception
	 * @throws BusinessException
	 */
	public String autoLogin(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws BusinessException {
		logger.info("autoLogin() - start");
		Cookie[] cookies = request.getCookies();
		for (int i = 0; i < cookies.length; i++) {
			Cookie cookie = cookies[i];
			if (cookie.getName().equals("smartweb-auth")) {
				String value = cookie.getValue();
				User user = domain.login(new Credentials(value));
				if (user == null) {
					return "failure";
				} else {
					request.getSession().setAttribute(UserAction.SESSION_KEY, user.getSecurityToken());
					cookie.setMaxAge(15 * 24 * 60 * 60);
					return "success";
				}
			}
		}
		return "disabled";
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws BusinessException
	 */
	public String logout(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws BusinessException {
		logger.info("logout() - start");
		domain.logout((String)request.getSession().getAttribute(UserAction.SESSION_KEY));
		request.getSession().invalidate();		
		return "success";
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws BusinessException
	 * @throws ActionException
	 */
	public String update(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws BusinessException, ActionException {
		User user = AbstractUserAction.getUser(request);
		if (user != null) {
			super.valorize(form, user, request.getLocale());
			domain.updateUser(user);
			return "success";
		}
		return "failure";
	}

	/**
	 * TODO documentation
	 * 
	 * @param form
	 * @param request
	 * @param response
	 * @param mapping
	 * @return
	 * @throws ActionException
	 * @throws BusinessException
	 */
	public String remove(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws BusinessException {
		User user = AbstractUserAction.getUser(request);
		if (user != null) {
			domain.removeUser(Long.toString(user.getId()));
		}
		return "success";
	}

	/**
	 * @see net.smartlab.web.Action#cancel(org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      org.apache.struts.action.ActionMapping)
	 */
	protected ActionForward cancel(ActionForm form, HttpServletRequest request, HttpServletResponse response,
			ActionMapping mapping) throws Exception {
		super.reset(form, request, mapping);
		return mapping.findForward("cancel");
	}
}
